use "SET PATH\data_kroeber_ejpr_2021.dta", clear




***************** DATA PREPARATION

**** Calculate GAL-TAN position of parties
* US: Include all variables
generate lib_aut=.
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5) if countryname=="United States"
* UK: Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="United Kindgom"
* Switzerland: Exclude per603, per608
replace lib_aut=log(per305+per601+per605+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5) if countryname=="Switzerland"
* Spain: Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Spain"
* Portugal: Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Portugal"
* Norway: Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Norway"
* New Zealand: Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="New Zealand"
* Latvia: Exclude per202 per201 per416 per602 per606 per603
replace lib_aut=log(per305+per601+per605+per608+0.5)-log(per501+ per604+ per502+ per607+ per705+ per706+0.5) if countryname=="Latvia"
* Israel: Exclude per706 per608 per305
replace lib_aut=log(per601+per603+per605+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per201+ per202+0.5) if countryname=="Israel"
* Ireland : Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Ireland"
* Iceland : Exclude per607 per608
replace lib_aut=log(per305+per601+per603+per605+per606+0.5)-log(per501+ per602+ per604+ per502+ per416+ per705+ per706+ per201+ per202+0.5) if countryname=="Iceland"
* Greece : Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Greece"
* Germany : Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Germany"
* Finland  : Exclude per502 per602
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per604+ per607+ per416+ per705+ per706+ per201+ per202+0.5) if countryname=="Finland"
* Denmark : Exclude per201 per602 per603
replace lib_aut=log(per305+per601+per605+per608+per606+0.5)-log(per501+  per604+ per502+ per607+ per416+ per705+ per706+  per202+0.5) if countryname=="Denmark"
* Czech Republic : Exclude per602
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5) if countryname=="Czech Republic"
* Canada : Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Canada"
* Bulgaria : Exclude per602
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5) if countryname=="Bulgaria"
* Austria : Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Austria"
* Australia : Include all variables
replace lib_aut=log(per305+per601+per603+per605+per608+per606+0.5)-log(per501+ per602+ per604+ per502+ per607+ per416+ per705+ per706+ per201+ per202+0.5)  if countryname=="Australia"


**** Calculate economic left-right position of parties
* US: Include all variables
generate economic=.
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="United States"
* United Kingdom: Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="United Kingdom"
* Switzerland: Exclude per405
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per409+per415+per503+0.5) if countryname=="Switzerland"
* Spain: Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Spain"
* Portugal: Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Portugal"
* Norway: Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Norway"
* New Zealand: Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="New Zealand"
* Latvia: Exclude per406 per403 per505 per507
replace economic=log(per401+per402+per407+per410+per414+per702+0.5)-log(per404+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Latvia"
* Israel: Exclude per405 per409 per415 per412 per406 per414
replace economic=log(per401+per402+per407+per505+per507+per410+per702+0.5)-log(per403+per404+per504+per506+per413+per701+per503+0.5) if countryname=="Israel"
* Ireland: Exclude per507
replace economic=log(per401+per402+per407+per505+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Ireland"
* Iceland: Exclude per702
replace economic=log(per401+per402+per407+per505+per507+per410+per414+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Iceland"
* Greece: Exclude per405
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per409+per415+per503+0.5) if countryname=="Greece"
* Germany: Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Germany"
* Finland: Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Finland"
* Denmark: Exclude per414 per506
replace economic=log(per401+per402+per407+per505+per507+per410+per702+0.5)-log(per403+per404+per406+per504+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Denmark"
* Czech Republic: Exclude per702
replace economic=log(per401+per402+per407+per505+per507+per410+per414+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Czech Republic"
* Canada: Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Canada"
* Bulgaria: Exclude per702
replace economic=log(per401+per402+per407+per505+per507+per410+per414+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Bulgaria"
* Austria : Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Austria"
* Australia : Include all variables
replace economic=log(per401+per402+per407+per505+per507+per410+per414+per702+0.5)-log(per403+per404+per406+per504+per506+per413+per412+per701+per405+per409+per415+per503+0.5) if countryname=="Australia"




***************** SET AS TIME-SERIES DATA

tsset  group election_count




***************** DESCRIPTIVE STATISTICS

sum d.lib_aut 
generate d_lib_aut=d.lib_aut
ttest d_lib_aut==0
sum d.economic
generate d_economic=d.economic
ttest d_economic==0

tab leader_women
tab women_leader_ever


*** Figure 1
graph twoway (kdensity d_lib_aut if leader_women==0) (kdensity d_lib_aut if leader_women==1)
graph save figure_1a.gph, replace
graph twoway (kdensity d_economic if leader_women==0) (kdensity d_economic if leader_women==1)
graph save figure_1b.gph, replace

graph combine  figure_1a.gph  figure_1b.gph
graph save figure_1.gph, replace




***************** MAIN MODELS

**** Model 1 (Table 2)
reg d.lib_aut l.lib_aut i.leader_women parliament_women_perc d.pervote  d.enp i.quota  i.group 
estimates store model1_lib_aut
vif
reg d.economic l.economic i.leader_women parliament_women_perc d.pervote  d.enp i.quota i.group  
estimates store model1_economic
vif

esttab   model1_lib_aut  model1_economic      using ///
"table2.rtf", ///
cells (b(star fmt(4)) se(par fmt(4))) compress ///
legend label title(Regression models) ///
star(* 0.05 ** 0.01 *** 0.001) ar2 replace 


**** Model 2-4 (Table3, Appendix 7)
generate left=0
replace left=1 if rile<0

reg d.lib_aut l.lib_aut i.leader_women##i.left c.parliament_women_perc d.pervote  d.enp i.quota  i.group
estimates store model2_1_lib_aut
reg d.economic l.economic i.leader_women##i.left c.parliament_women_perc d.pervote  d.enp i.quota i.group  
estimates store model2_2_economic

reg d.lib_aut l.lib_aut i.leader_women##i.greens c.parliament_women_perc d.pervote  d.enp i.quota  i.group
estimates store model3_1_lib_aut
reg d.economic l.economic i.leader_women##i.greens c.parliament_women_perc d.pervote  d.enp i.quota i.group
estimates store model3_2_economic

reg d.lib_aut l.lib_aut i.leader_women i.women_leader_ever parliament_women_perc d.pervote  d.enp i.quota  i.group 
estimates store model4_1_lib_aut
reg d.economic l.economic i.leader_women  i.women_leader_ever parliament_women_perc d.pervote  d.enp i.quota i.group 
estimates store model4_2_economic

generate leader_woman_after_man=.
replace leader_woman_after_man=0 if leader_women!=.
replace leader_woman_after_man=1 if leader_women==1 & l.leader_women==0

reg d.lib_aut l.lib_aut i.leader_women i.leader_woman_after_man parliament_women_perc d.pervote  d.enp i.quota  i.group 
estimates store model5_1_lib_aut
reg d.economic l.economic i.leader_women i.leader_woman_after_man parliament_women_perc d.pervote  d.enp i.quota i.group  
estimates store model5_2_economic

esttab model2_1_lib_aut  model3_1_lib_aut  model4_1_lib_aut  model5_1_lib_aut model2_2_economic  model3_2_economic model4_2_economic  model5_2_economic  using ///
"tableA7.rtf", ///
cells (b(star fmt(4)) se(par fmt(4))) compress ///
legend label title(Regression models) ///
star(+ 0.1 * 0.05 ** 0.01 *** 0.001) ar2 replace 


********** Model 5 (Figure 2, Appendix 8-9)
reg d.per305 l.per305 i.leader_women parliament_women_perc   d.pervote  d.enp i.quota  i.group if countryname!="Israel", level(90)
estimates store model_per305

reg d.per601 l.per601 i.leader_women parliament_women_perc   d.pervote  d.enp i.quota  i.group, level(90)
estimates store model_per601

reg d.per603 l.per603 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group if country_name!="Denmark", level(90)
estimates store model_per603

reg d.per605 l.per605 i.leader_women parliament_women_perc   d.pervote  d.enp i.quota  i.group, level(90)
estimates store model_per605

reg d.per608 l.per608 i.leader_women parliament_women_perc   d.pervote  d.enp i.quota  i.group if countryname!="Israel" & country_name!="Iceland", level(90)
estimates store model_per608

reg d.per606 l.per606 i.leader_women parliament_women_perc   d.pervote  d.enp i.quota  i.group , level(90)
estimates store model_per606

reg d.per501 l.per501 i.leader_women parliament_women_perc   d.pervote  d.enp i.quota  i.group , level(90)
estimates store model_per501

reg d.per602 l.per602 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group if country_name!="Finland" & country_name!="Denmark" & country_name!="Czech Republic" & country_name!="Bulgaria" ,  level(90)
estimates store model_per602

reg d.per604 l.per604 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group , level(90)
estimates store model_per604

reg d.per502 l.per502 i.leader_women parliament_women_perc   d.pervote  d.enp i.quota  i.group if country_name!="Finland" , level(90)
estimates store model_per502

reg d.per607 l.per607 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group if country_name!="Iceland" , level(90)
estimates store model_per607

reg d.per416 l.per416 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group , level(90)
estimates store model_per416

reg d.per705 l.per705 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group , level(90)
estimates store model_per705

reg d.per706 l.per706 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group if countryname!="Israel" , level(90)
estimates store model_per706

reg d.per201 l.per201 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group if country_name!="Denmark" , level(90)
estimates store model_per201

reg d.per202 l.per202 i.leader_women parliament_women_perc  d.pervote  d.enp i.quota  i.group , level(90)
estimates store model_per202


**** Appendix 8: Full models (part 1)
esttab model_per305 model_per601 model_per603 model_per605 model_per608 model_per606 model_per501 model_per602 model_per604 model_per502 model_per607 model_per416 model_per705  model_per706 model_per201 model_per202 using ///
"table_A8.rtf", ///
cells (b(fmt(4)) ci(par fmt(4) )) compress ///
legend label title(Regression models) ///
star(* 0.05 ** 0.01 *** 0.001) level(90) replace 

**** Appendix 9: Full models (part 2)
esttab model_per305 model_per601 model_per603 model_per605 model_per608 model_per606 model_per501 model_per602 model_per604 model_per502 model_per607 model_per416 model_per705  model_per706 model_per201 model_per202 using ///
"table_A9.rtf", ///
cells (b(star fmt(4)) se(par fmt(4))) compress ///
legend label title(Regression models) ///
star(* 0.05 ** 0.01 *** 0.001) ar2 replace 

**** Figure 2
coefplot  (model_per416, label("Anti-growth")) (model_per501, label("Environmental Protection")) (model_per201, label("Freedom and Human Rights"))  (model_per706, label("Non-economic Demographic Groups")) (model_per502, label("Culture: Positive")) (model_per705, label("Underprivilegend Minority Groups")) (model_per603, label("Traditional Morality: Positive")) (model_per604, label("Traditional Morality: Negative")) (model_per202, label("Democracy"))  (model_per605, label("Law and Order"))   (model_per606, label("Social Harmony"))  (model_per602, label("National Way of Life: Negative")) (model_per607, label("Multiculturalism: Positive")) (model_per608, label("Multiculturalism: Negative"))   (model_per305, label("Political Authority"))  (model_per601, label("National Way of Life: Positive"))   ///
, keep(*.leader_women) 

graph save figure_2.gph, replace




***************** ROBUSTNESS TESTS

**** Appendix 3: Model T1, with jackknife SEs
reg d.lib_aut l.lib_aut i.leader_women parliament_women_perc d.pervote  d.enp i.quota  i.group, vce(jackknife) 
estimates store modelT1_1_lib_aut
reg d.economic l.economic i.leader_women parliament_women_perc d.pervote  d.enp i.quota  i.group, vce(jackknife) 
estimates store modelT1_2_economic 

esttab   modelT1_1_lib_aut modelT1_2_economic   using ///
"tableT1.rtf", ///
cells (b(star fmt(4)) se(par fmt(4))) compress ///
legend label title(Regression models) ///
star(* 0.05 ** 0.01 *** 0.001) ar2  replace 


**** Appendix 4: Model T2, multi-level model
mixed d.lib_aut l.lib_aut i.leader_women parliament_women_perc d.pervote  d.enp i.quota  i.group  || country: || group:
estimates store modelT2_1_lib_aut
mixed d.economic l.economic i.leader_women parliament_women_perc d.pervote  d.enp i.quota i.group if lib_aut!=. || country: || group:
estimates store modelT2_2_economic

esttab   modelT2_1_lib_aut modelT2_2_economic  using ///
"tableT2.rtf", ///
cells (b(star fmt(4)) se(par fmt(4))) compress ///
legend label title(Regression models) ///
star(* 0.05 ** 0.01 *** 0.001)  replace 


***** Appendix 5: Model T3-6 alternative measures for share of women in parliament 
generate women_cat=.
replace women_cat=0 if parliament_women_perc<5
replace women_cat=1 if parliament_women_perc>=5 & parliament_women_per<15
replace women_cat=2 if parliament_women_perc>=15 & parliament_women_per<30
replace women_cat=3 if parliament_women_perc>=30
replace women_cat=. if parliament_women_perc==.

reg d.lib_aut l.lib_aut i.leader_women i.women_cat d.pervote  d.enp i.quota  i.group  
estimates store modelT3_1_lib_aut
reg d.economic l.economic i.leader_women i.women_cat d.pervote  d.enp i.quota i.group  
estimates store modelT3_2_economic

reg d.lib_aut l.lib_aut i.leader_women c.parliament_women_perc##c.parliament_women_perc d.pervote  d.enp i.quota  i.group
estimates store modelT4_1_lib_aut
reg d.economic l.economic i.leader_women c.parliament_women_perc##c.parliament_women_perc d.pervote  d.enp i.quota i.group
estimates store modelT4_2_economic

replace parliament_women_abs=round((parliament_women_perc/100)*l.absseat) if parliament_women_abs==. & parliament_women_perc!=.
generate log_women_abs=log(1+ parliament_women_abs)

reg d.lib_aut l.lib_aut i.leader_women log_women_abs d.pervote  d.enp i.quota  i.group 
estimates store modelT5_1_lib_aut 
reg d.economic l.economic i.leader_women log_women_abs d.pervote  d.enp i.quota i.group 
estimates store modelT5_2_economic

reg d.lib_aut l.lib_aut i.leader_women d.parliament_women_perc  d.pervote  d.enp i.quota  i.group
estimates store modelT6_1_lib_aut
reg d.economic l.economic i.leader_women d.parliament_women_perc  d.pervote  d.enp i.quota i.group 
estimates store modelT6_2_economic

esttab  modelT3_1_lib_aut modelT3_2_economic modelT4_1_lib_aut modelT4_2_economic modelT5_1_lib_aut modelT5_2_economic modelT6_1_lib_aut modelT6_2_economic using ///
"tableA5.rtf", ///
cells (b(star fmt(4)) se(par fmt(4))) compress ///
legend label title(Regression models) ///
star(* 0.05 ** 0.01 *** 0.001) ar2 replace 


***** Appendix 6: Model T7 Variable for leadership selection inclusiveness 
reg d.lib_aut l.lib_aut i.leader_women parliament_women_perc d.pervote  d.enp i.quota  i.leaderselection_inclusiveness i.group 
estimates store modelT7_1_lib_aut
reg d.economic l.economic i.leader_women parliament_women_perc d.pervote  d.enp i.quota i.leaderselection_inclusiveness i.group  
estimates store modelT7_2_economic

esttab   modelT7_1_lib_aut modelT7_2_economic using ///
"tableA6.rtf", ///
cells (b(star fmt(4)) se(par fmt(4))) compress ///
legend label title(Regression models) ///
star(* 0.05 ** 0.01 *** 0.001) ar2 replace 