# Overview

This folder contains all of the replication materials for:

Lupu, Noam, and Zach Warner. Forthcoming. "Why Are the Affluent Better Represented Around the World?" **European Journal of Political Research**.

# Manifest

The folder structure is as follows:

data/
... Lupu-Warner-Why-Are.csv
logs/
... Dockerfile
results/
... variable-importances/
scripts/
... Lupu-Warner-Why-Are.R
Lupu-Warner-Why-Are.sh
README.md

# File description

- /data/Lupu-Warner-Why-Are.csv provides all of the data used in the manuscript and in the Online Appendix.
- /logs/Dockerfile is the Dockerfile from which the replication Docker image was built. Note that this is unlikely to compile now; it is provided merely for historical reference.
- /results/ is the folder in which all results are stored after the replication script is run.
- /results/variable-importances/ is the folder in which variable importance results are stored; these are intermediate files generated by the script but are not directly used in the manuscript.
- /scripts/Lupu-Warner-Why-Are.R is the R script that reproduces all the results in the manuscript and the Online Appendix.
- Lupu-Warner-Why-Are.sh is the master file that is used to generate a Docker container so that the analysis script can be run in a reproducible environment.

# Complete replication

To precisely replicate our results, users should install Docker desktop and make sure it is running. They will then need to edit line 8 of the master file, Lupu-Warner-Why-Are.sh, which simply sets the directory to this replication folder. Finally, they should open a command line environment (e.g., Terminal on a unix system or PowerShell on Windows) and run each line of code in the master file.

The master file itself will create a Docker container from a pre-built image pulled from Docker Hub. This image is the exact environment in which our results were obtained. The master file will then launch the container, run the analysis script, and close the container.

The code takes approximately 90 minutes to run on an Ubuntu machine with 32Gb of RAM (and 150 minutes on a MacBook Air with 8Gb of RAM). The output Tables and Figures (for both the manuscript and the Online Appendix) will be in /results. The log from the R session will be available in /logs.

As noted in the /scripts/Lupu-Warner-Why-Are.R file, please ensure that the /results/variable-importances/ folder is empty before attempting a replication run, otherwise the script will produce errors.

# Exploratory analysis

If users instead wish just to see how the code works, they can run the file /scripts/Lupu-Warner-Why-Are.R interactively. Note, however, that different operating system, R, and package versions might cause results to not replicate precisely.

# Contact

For any questions or problems, please email Zach (whose current email is listed on zachwarner.net).

Last edited January 2, 2021.