
// Run this file to replicate the analysis
// For STATA 16.1



/*
/* Input your own path */ use "corona_trust_EJPR_data", clear
/* Input your own path */ cd ""
/* Input your own path */ local path ""
*/


// In the main manuscript, we test two hypotheses:
*** H1:	The coronavirus crisis increases levels of institutional trust. 
*** H2:	The coronavirus crisis increases levels of social trust.

// Pre-registration of hypotheses available at https://osf.io/bm2a6.
// In the pre-registration, H1 is referred to as H1a. 
// In this do-file, the hypotheses are labeled and ordered according to the pre-registration.
// Tests of H1b, H3a, H3b and H4 are reported in the SI. H5 is not tested. 
 
*** H1a/H1:	The coronavirus crisis increases levels of institutional trust. 
*** H1b:	If the coronavirus crisis is made salient, then levels of institutional trust increase.
*** H2:		The coronavirus crisis increases levels of social trust.
*** H3a:	The coronavirus crisis increases the polarization of institutional trust.
*** H3b: 	If the coronavirus crisis is made salient, then there is greater polarization of institutional trust.
*** H4: 	The coronavirus crisis increases the polarization of social trust.
*** H5: 	A higher level of institutional trust leads to a higher level of social trust.

// Cohen's d for paired-t tests calculated based on eq 7 in https://www.frontiersin.org/articles/10.3389/fpsyg.2013.00863/full

// Packages: vreverse, blindschemes, tabout, coefplot, grc1leg2
// Graph scheme: plotplain

set scheme plotplain



*** DATA MANAGEMENT, WIDE ***


// Institutional trust and social trust variables, abbreviations and recodings:
// it: institutional trust
// st: social/interpersonal trust
// int: integer 
// 01: 0 to 1 coding (normalized)
// pre: survey at t-1, 
// t0: survey at t0
// t1: survey at t1

vreverse q161_wpre0, gen(it_int_tpre)
vreverse q358_w0, gen(it_int_t0)
egen qit_orig_w1 = rowfirst(q12_w1 q76_w1)
vreverse qit_orig_w1, gen(it_int_t1)
gen st_int_tpre = q173_wpre0
gen st_int_t0 = q368_w0
egen st_int_t1 = rowfirst(q22_w1 q86_w1)

gen it_01_tpre = (it_int_tpre-1)/4
gen it_01_t0 = (it_int_t0-1)/4
gen it_01_t1 = (it_int_t1-1)/4
gen st_01_tpre = (st_int_tpre-1)/4
gen st_01_t0 = (st_int_t0-1)/4
gen st_01_t1 = (st_int_t1-1)/4

la var it_01_tpre "Institutional trust, t-1"
la var it_01_t0 "Institutional trust, t0"
la var it_01_t1 "Institutional trust, t1"
la var st_01_tpre "Interpersonal trust, t-1"
la var st_01_t0 "Interpersonal trust, t0"
la var st_01_t1 "Interpersonal trust, t1"

// Change over time in trust 
gen itdelta_short = it_01_t1-it_01_t0
gen itdelta_long = it_01_t1-it_01_tpre

gen stdelta_short = st_01_t1-st_01_t0
gen stdelta_long = st_01_t1-st_01_tpre


//Experimental group (priming or not)
gen exper = . 
recode exper . = 1 if experiment1_w1==1
recode exper . = 0 if experiment1_w1==0
recode exper . = 0 if kontroll_w1==1
la var exper "Priming experiment"
la def exper 0 "Control condition" 1 "Priming condition", replace
la val exper exper

// Participation dates:
generate date_tpre = string(complete_date_wpre0,"%tdCCYY-NN-DD")
replace date_tpre = "" if date_tpre=="."
la var date_tpre "Date started"

generate date_t0 = string(complete_date_w0,"%tdCCYY-NN-DD")
replace date_t0 = "" if date_t0=="."
la var date_t0 "Date started"

generate date_t1 = string(complete_date_w1,"%tdCCYY-NN-DD")
replace date_t1 = "" if date_t1=="."
la var date_t1 "Date started"


// Background variables (sex, age, education, income, location):
recode sex 1=1 2=2 3=., gen(sex2)
la var sex2 "Sex"
la def sex2 1 "Female" 2 "Male", replace
la val sex2 sex2

gen age = age6
la var age "Age"
la def age 1 "< 30" 2 "30-39" 3 "40-49" 4 "50-59" 5 "60-69" 6 "≥ 70", replace
la val age age

gen educ = utbildning
la var educ "Highest level of education"
la def educ 1 "Not completed elementary school" 2 "Completed elementary school" ///
3 "High school, < 3 years" 4 "High school, ≥ 3 years" ////
5 "Post-secondary education, < 3 years" ///
6 "Post-secondary education, ≥ 3 years" ///
7 "College/University, < 3 years" 8 "College/University, ≥ 3 years" ///
9 "Doctoral degree", replace
la val educ educ

gen inc = pinc
la var inc "Income (individual) in SEK"
la def inc 1 "< 4,000" 2 "4,000 - 8,999" 3 "9,000 - 12,999" 4 "13,000 - 15,999" ///
5 "16,000 - 18,999" 6 "19,000 - 22,999" 7 "23,000 - 25,999" 8 "26,000 - 29,999" ///
9 "30,000 - 36,999" 10 "37,000 - 44,999" 11 "45,000 - 54,999" 12 "55,000 - 64,999" ///
13 "≥ 65,000" 14 "Don't know/Refusal" 15 "Other", replace
la val inc inc

gen urbrur = muni7
la var urbrur "Location"
la def urbrur 1 "Large city (central)" 2 "Large city (suburb)" 3 "City (central)" ///
4 "City (outskirts)" 5 "Town" 6 "Small town" 7 "Countryside", replace
la val urbrur urbrur


// Recode of party support for exploratory analysis of heterogenous effects:
gen partysdmkd = .
recode partysdmkd . = 1 if pvint==5 | pvint==6 | pvint==8
recode partysdmkd . = 0 if pvint==1 | pvint==2 | pvint==3 | pvint==4 | pvint==7 | pvint==9 | pvint==10 | pvint==11 | pvint==12 | pvint==13 | pvint==14 | pvint==15

gen partyothdkref = .
recode partyothdkref . = 1 if pvint==9 | pvint==10 | pvint==11 | pvint==12 | pvint==13 | pvint==14 | pvint==15
recode partyothdkref . = 0 if pvint==1 | pvint==2 | pvint==3 | pvint==4 | pvint==7 | pvint==5 | pvint==6 | pvint==8


// Participation at panel waves t-1, t0, t1 
gen partic_tpre = wavepre0
recode partic_tpre . = 0
la var partic_tpre "t-1 participation"
la def partic_tpre 0 "No" 1 "Yes"
la val partic_tpre partic_tpre

gen partic_t0 = wave0
recode partic_t0 . = 0
la var partic_t0 "t0 participation"
la def partic_t0 0 "No" 1 "Yes"
la val partic_t0 partic_t0

gen partic_t1 = wave1
recode partic_t1 . = 0
la var partic_t1 "t1 participation"
la def partic_t1 0 "No" 1 "Yes"
la val partic_t1 partic_t1

// Panel attrition dv:
gen partic_t0_t1 = .
recode partic_t0_t1 . = 1 if wave0 == 1 & wave1 == 1
recode partic_t0_t1 . = 0 if wave0 == 1 & missing(wave1)


// Preanalysis plan was to exclude responses from it and st at t0 if R participated between 20200311 and 20200319.
di date("20200311","YMD")
di date("20200319","YMD")
recode it_01_t0 st_01_t0 (0/1 = .) if complete_date_w0==21985 | complete_date_w0==21986 | ///
complete_date_w0==21987 | complete_date_w0==21988 | complete_date_w0==21989 | complete_date_w0==21990 | ///
complete_date_w0==21991 | complete_date_w0==21992 | complete_date_w0==21993       
* it removed: n = 644
* st removed: n = 640




*** DESCRIPTIVES, WIDE ***


* Tables S2-S4. Participation dates.

/* t-1 */ tabout date_tpre using table_s2_date_tpre.csv, cells(freq col cum) format(0c 2c 2c) clab(Freq. Percent Cum.) replace 
/* t0 */ tabout date_t0 using table_s3_date_t0.csv, cells(freq col cum) format(0c 2c 2c) clab(Freq. Percent Cum.) replace 
/* t1 */ tabout date_t1 using table_s4_date_t1.csv, cells(freq col cum) format(0c 2c 2c) clab(Freq. Percent Cum.) replace 


* Table S6. Respondent characteristics at t-1, t0 and t1.

/* t-1 */ tabout sex2 age educ inc urbrur if partic_tpre == 1 using table_s6_background_tpre.csv, ///
oneway cells(freq col cum) format(0c 2c 2c) clab(Freq. Percent Cum.) replace 
/* t0 */ tabout sex2 age educ inc urbrur if partic_t0 == 1 using table_s6_background_t0.csv, ///
oneway cells(freq col cum) format(0c 2c 2c) clab(Freq. Percent Cum.) replace
/* t1 */ tabout sex2 age educ inc urbrur if partic_t1 == 1 using table_s6_background_t1.csv, ///
oneway cells(freq col cum) format(0c 2c 2c) clab(Freq. Percent Cum.) replace

* Table S7. Descriptive statistics of institutional and interpersonal trust.

log using "table_s7_it&st_descriptives.log", replace
sum it_01_tpre it_01_t0 it_01_t1 st_01_tpre st_01_t0 st_01_t1
log close


* Table S8. Correlation matrix of institutional and interpersonal trust.

log using "table_s8_correlations.log", replace
/* Pairwise deletion */ pwcorr it_01_tpre it_01_t0 it_01_t1 st_01_tpre st_01_t0 st_01_t1, obs sig 
log close



*** ANALYSIS, WIDE ***


* Figure 2. Institutional trust by survey participation date.

* Show Stata format of dates for the data collection
di date("20200224","YMD")
di date("20200310","YMD")
di date("20200331","YMD")
di date("20200414","YMD")

lpoly it_01_t0 complete_date_w0, bw(3) noscatter ci ylab(.6(.05).8, format(%5.2f)) ytitle("Institutional trust") xlabel(21969 "February 24" 21984 "March 10", nogrid) xtitle("") title("t0") legend(label(1 "95% CI") label(2 "Local polynomial estimate") position(6) row(1)) note("") name(it_01_t0_lpoly, replace)
lpoly it_01_t1 complete_date_w1, bw(3) noscatter ci ylab(.6(.05).8, format(%5.2f)) ytitle("") xlabel(22005 "March 31" 22019 "April 14", nogrid) xtitle("") title("t1") legend(label(1 "95% CI") label(2 "Local polynomial estimate") position(6) row(1)) note("") name(it_01_t1_lpoly, replace)
/* Combine figures */ grc1leg2 it_01_t0_lpoly it_01_t1_lpoly, col(2) ycommon ysize(5) xsize(7) scale(1.1) title("")
/* Figure 2 */ graph export  "`path'figure2_it_lpoly.png", replace


* T-tests on mean differences in institutional trust reported in the main:

/* t-test: t0 to t1 */ ttest it_01_t1 == it_01_t0 if !missing(it_01_t0) & !missing(it_01_t1) & exper==0
/* Cohen's d (paired) */ display  45.2428/sqrt(7206)
/* ttest: t0 to t1, representative */ ttest it_01_t1 == it_01_t0 if !missing(it_01_tpre) & !missing(it_01_t0) & !missing(it_01_t1)
/* Cohen's d (paired) */ display  20.8567/sqrt(1415)
/* ttest: t-1 to t1, representative */ ttest it_01_t1 == it_01_tpre if !missing(it_01_tpre) & !missing(it_01_t0) & !missing(it_01_t1)
/* Cohen's d (paired) */ display  17.2467/sqrt(1415)


* Figure 4. Interpersonal trust by survey participation date.

lpoly st_01_t0 complete_date_w0, bw(3) noscatter ci ylab(.6(.05).8, format(%5.2f)) ytitle("Interpersonal trust") xlabel(21969 "February 24" 21984 "March 10", nogrid) xtitle("") title("t0") legend(label(1 "95% CI") label(2 "Local polynomial estimate") position(6) row(1)) note("") name(st_01_t0_lpoly, replace)
lpoly st_01_t1 complete_date_w1, bw(3) noscatter ci ylab(.6(.05).8, format(%5.2f)) ytitle("") xlabel(22005 "March 31" 22019 "April 14", nogrid) xtitle("") title("t1") legend(label(1 "95% CI") label(2 "Local polynomial estimate") position(6) row(1)) note("") name(st_01_t1_lpoly, replace)
/* Combine figures */ grc1leg2 st_01_t0_lpoly st_01_t1_lpoly, col(2) ycommon ysize(5) xsize(7) scale(1.1) title("")
/* Figure 4 */ graph export  "`path'figure4_st_lpoly.png", replace

* T-tests on mean differences in interpersonal trust reported in the main:

/* t-test: t0 to t1, large */ ttest st_01_t1 == st_01_t0 if !missing(st_01_t0) & !missing(st_01_t1) & exper==0
/* Cohen's d (paired) */ display  5.9638/sqrt(7183)
/* ttest: t0 to t1, representative */  ttest st_01_t1 == st_01_t0 if !missing(st_01_tpre) & !missing(st_01_t0) & !missing(st_01_t1)
/* Cohen's d (paired) */ display  2.5035/sqrt(1406)
/* ttest: t-1 to t1, representative */ttest st_01_t1 == st_01_tpre if !missing(st_01_tpre) & !missing(st_01_t0) & !missing(st_01_t1)
/* Cohen's d (paired) */ display  2.8959/sqrt(1406)



* Table S10. Coronavirus priming experiment effect on institutional trust (OLS, coefficients).

// Analysis with all participants at t1 in regression framework:
/* (H1b) Treatment as a dummy */ reg it_01_t1 i.exper, robust
/* (H1b) Model 1 */ outreg2 using table_s10_it_experiment.doc, replace title(Priming corona experiment) ctitle(Model 1) dec(3)
/* (H1b) Means & CI:s by condition */ margins, at(exper=(0 1))
/* (H1b) Including lagged it */ reg it_01_t1 i.exper it_01_t0, robust
/* (H1b) Model 2 */ outreg2 using table_s10_it_experiment.doc, append ctitle(Model 2) dec(3)
/* (H3b) Conditional treatment effect by lagged it */ reg it_01_t1 i.exper##c.it_01_t0, robust
/* (H3b) Model 3 */ outreg2 using table_s10_it_experiment.doc, append ctitle(Model 3) dec(3)

// The three models below exclude t-1 participants from the analysis because 
// they could not be assigned to the treatment condition. Otherwise, the models 
// are exactly the same as the three models above.
/* (H1b) Treatment as a dummy */ reg it_01_t1 i.exper if wavepre0!=1, robust
/* (H1b) Model 4 */ outreg2 using table_s10_it_experiment.doc, append ctitle(Model 4) dec(3)
/* (H1b) Including lagged it */ reg it_01_t1 i.exper it_01_t0 if wavepre0!=1, robust
/* (H1b) Model 5 */ outreg2 using table_s10_it_experiment.doc, append ctitle(Model 5) dec(3)
/* (H3b) Conditional treatment effect by lagged it */ reg it_01_t1 i.exper##c.it_01_t0 if wavepre0!=1, robust
/* (H3b) Model 6 */ outreg2 using table_s10_it_experiment.doc, append ctitle(Model 6) dec(3)

/* t-test: Values in results section */ ttest it_01_t1, by(exper)



* Table S11. Differential change between t-1, t0 and t1 in institutional and interpersonal trust (change scores)

/* Large sample short period */ reg itdelta_short c.it_01_t0 if !missing(it_01_t0) & !missing(it_01_t1) & exper==0, robust
outreg2 using table_s11_it_polariz.doc, replace title(Differential change over time in institutional trust) ctitle(Large sample short period) dec(3)
margins, at(it_01_t0=(0(.2)1))
marginsplot, recast(line) recastci(rarea) ylab(-.1(.05).3, format(%5.2f)) xtitle("Institutional trust at t0") xlabel(0 "Very low" .25 "Rather low" .5 "Neither" .75 "Rather high" 1 "Very high", nogrid labsize(2)) yline(0) ytitle("Change in institutional trust from t0 to t1") graphregion(margin(l+5 r+5 t+0 b+0)) plotregion(margin(l+5 r+5 t+0 b+0))
/* Figure S4 */ graph export  "`path'figure_s4_it_polariz.png", replace
/* Representative sample short period */  reg itdelta_short c.it_01_t0 if !missing(it_01_tpre) & !missing(it_01_t0) & !missing(it_01_t1), robust
outreg2 using table_s11_it_polariz.doc, append  ctitle(Representative sample short period) dec(3)
/* Representative sample long period */  reg itdelta_long c.it_01_tpre if !missing(it_01_tpre) & !missing(it_01_t0) & !missing(it_01_t1), robust
outreg2 using table_s11_it_polariz.doc, append ctitle(Representative sample long period) dec(3)

/* Large sample short period */ reg stdelta_short c.st_01_t0 if !missing(st_01_t0) & !missing(st_01_t1) & exper==0, robust
outreg2 using table_s11_st_polariz.doc, replace title(Differential change over time in interpersonal trust) ctitle(Large sample short period) dec(3)
margins, at(st_01_t0=(0(.1)1))
marginsplot, recast(line) recastci(rarea) ylab(-.1(.05).3, format(%5.2f)) xtitle("Interpersonal trust at t0") xlabel(0 `" "People cannot" "generally be trusted" "' .25 " " .5 " " .75 " " 1 `" "People can " "generally be trusted" "', nogrid labsize(2)) yline(0) ytitle("Change in interpersonal trust from t0 to t1") graphregion(margin(l+5 r+5 t+0 b+0)) plotregion(margin(l+5 r+5 t+0 b+0))
/* Figure S5 */ graph export  "`path'figure_s5_st_polariz.png", replace
/* Representative sample short period */ reg stdelta_short c.st_01_t0 if !missing(st_01_tpre) & !missing(st_01_t0) & !missing(st_01_t1), robust
outreg2 using table_s11_st_polariz.doc, append  ctitle(Representative sample short period) dec(3)
/* Representative sample long period */ reg stdelta_long c.st_01_tpre if !missing(st_01_tpre) & !missing(st_01_t0) & !missing(st_01_t1), robust
outreg2 using table_s11_st_polariz.doc, append ctitle(Representative sample long period) dec(3)



* Table S12. Heterogenous change over time in institutional trust and interpersonal trust

/* Large sample short period */ reg itdelta_short educ age partysdmkd partyothdkref if !missing(it_01_t0) & !missing(it_01_t1) & exper==0, robust
outreg2 using table_s12_itpolarizother.doc, replace title(Differential change over time in institutional trust) ctitle(Large sample short period) dec(3)
margins, at(educ=(1 9))
margins, at(age=(1 6))
margins, at(partysdmkd=(0 1))
/* Representative sample short period */  reg itdelta_short educ age partysdmkd partyothdkref if !missing(it_01_tpre) & !missing(it_01_t0) & !missing(it_01_t1), robust
outreg2 using table_s12_itpolarizother.doc, append  ctitle(Representative sample short period) dec(3)
/* Representative sample long period */  reg itdelta_long educ age partysdmkd partyothdkref if !missing(it_01_tpre) & !missing(it_01_t0) & !missing(it_01_t1), robust
outreg2 using table_s12_itpolarizother.doc, append ctitle(Representative sample long period) dec(3)

/* Large sample short period */ reg stdelta_short educ age partysdmkd partyothdkref if !missing(st_01_t0) & !missing(st_01_t1) & exper==0, robust
outreg2 using table_s12_stpolarizother.doc, replace title(Differential change over time in interpersonal trust) ctitle(Large sample short period) dec(3)
/* Representative sample short period */ reg stdelta_short educ age partysdmkd partyothdkref if !missing(st_01_tpre) & !missing(st_01_t0) & !missing(st_01_t1), robust
outreg2 using table_s12_stpolarizother.doc, append  ctitle(Representative sample short period) dec(3)
/* Representative sample long period */ reg stdelta_long educ age partysdmkd partyothdkref if !missing(st_01_tpre) & !missing(st_01_t0) & !missing(st_01_t1), robust
outreg2 using table_s12_stpolarizother.doc, append ctitle(Representative sample long period) dec(3)


* Table S13. Panel attrition between t0 and t1

logit partic_t0_t1 age sex2 educ, or
outreg2 using table_s13_attritiont0_t1.doc, eform pvalue noaster bracket title(Attrition between t0 and t1) ctitle(Model 1) dec(2) replace  
margins, at(age=(1(1)6))
margins, at(sex2=(1 2))
margins, at(educ=(1(1)9))


*** END, ANALYSIS WIDE ***






*** DATA MANAGEMENT, LONG ***


// The four variables below are created for the analysis in long format to focus on the individuals with no missing on the central variables
gen it_nomisstpret0t1 = .
recode it_nomisstpret0t1 . = 1 if !missing(it_01_tpre) & !missing(it_01_t0) & !missing(it_01_t1)
gen it_nomisst0t1 = .
recode it_nomisst0t1 . = 1 if !missing(it_01_t0) & !missing(it_01_t1)
gen st_nomisstpret0t1 = .
recode st_nomisstpret0t1 . = 1 if !missing(st_01_tpre) & !missing(st_01_t0) & !missing(st_01_t1)
gen st_nomisst0t1 = .
recode st_nomisst0t1 . = 1 if !missing(st_01_t0) & !missing(st_01_t1)


drop if exper == 1

rename it_01_tpre it1
rename it_01_t0 it2
rename it_01_t1 it3
rename st_01_tpre st1
rename st_01_t0 st2
rename st_01_t1 st3
rename complete_date_wpre0 date1
rename complete_date_w0 date2
rename complete_date_w1 date3

keep it1 it2 it3 st1 st2 st3 date1 date2 date3 sex2 age educ inc urbrur it_nomisstpret0t1 it_nomisst0t1 st_nomisstpret0t1 st_nomisst0t1

gen id = _n
reshape long it st date, i(id) j(w) 
xtset id w
la var w "t"
la def w 1 "t-1" 2 "t0" 3 "t1", replace
la val w w



*** ANALYSIS, LONG ***


//Institutional trust:


* Table S9. Institutional and interpersonal trust between t-1, t0 and t1 (mean values)

//Institutional trust:
/* Same individuals as t-test above, large sample */ xtreg it i.w if it_nomisst0t1==1 & w>1, fe cluster(id)
outreg2 using table_s9_h1h2.doc, replace title(Change over time in institutional and interpersonal trust?) ctitle(Institutional trust, large sample) dec(3)
/* Same individuals as t-test, representative sample */ xtreg it i.w if it_nomisstpret0t1 == 1, fe cluster(id)
outreg2 using table_s9_h1h2.doc, append ctitle(Institutional trust, representative sample) dec(3)

//Interpersonal trust:
/* Same individuals as t-test above, large sample */ xtreg st i.w if st_nomisst0t1==1 & w>1, fe cluster(id)
outreg2 using table_s9_h1h2.doc, append ctitle(Interpersonal trust, large sample) dec(3)
/* Same individuals as t-test, representative sample */ xtreg st i.w if st_nomisstpret0t1 == 1, fe cluster(id)
outreg2 using table_s9_h1h2.doc, append ctitle(Interpersonal trust, representative sample) dec(3)


* Figure 3. Mean values of institutional trust over time.

xtreg it i.w if it_nomisst0t1==1 & w>1, fe cluster(id)
regress, coeflegend noheader
margins, at(w=(2 3)) post
estimates store it_nomisst0t1

xtreg it i.w if it_nomisstpret0t1 == 1, fe cluster(id)
regress, coeflegend noheader
margins, at(w=(1 2 3)) post
estimates store it_nomisstpret0t1

coefplot (it_nomisst0t1, label(Large sample) rename(1._at = "t0" 2._at = "t1") offset(-.1) msize(small) msymbol(smcircle)) (it_nomisstpret0t1, label(Representative sample) rename(1._at = "t-1" 2._at = "t0" 3._at = "t1") offset(.1) msize(small) msymbol(smdiamond)), ytitle(Institutional trust) vertical base levels(95) ylab(.6(.05).75, format(%5.2f)) xlabel(, nogrid) xtitle("") order("t-1" "t0" "t1")
graph export  "`path'figure3_it_means.png", replace


*Figure 5. Mean values of interpersonal trust over time.  
xtreg st i.w if st_nomisst0t1==1 & w>1, fe cluster(id)
regress, coeflegend noheader
margins, at(w=(2 3)) post
estimates store st_nomisst0t1

xtreg st i.w if st_nomisstpret0t1 == 1, fe cluster(id)
regress, coeflegend noheader
margins, at(w=(1 2 3)) post
estimates store st_nomisstpret0t1

coefplot (st_nomisst0t1, label(Large sample) rename(1._at = "t0" 2._at = "t1") offset(-.1) msize(small) msymbol(smcircle)) (st_nomisstpret0t1, label(Representative sample) rename(1._at = "t-1" 2._at = "t0" 3._at = "t1") offset(.1) msize(small) msymbol(smdiamond)), ytitle(Interpersonal trust) vertical base levels(95) ylab(.65(.05).8, format(%5.2f) gmin gmax) xlabel(, nogrid) xtitle("") order("t-1" "t0" "t1")
graph export  "`path'figure5_st_means.png", replace


