###########
# Replication code for: Stability and Change in Political Trust: Evidence and implications from six panel studies
# Daniel Devine and Viktor Valgardsson
# European Journal of Political Research
# 16/12/2022
###########

##### Session details #####
# > sessionInfo()
# R version 4.1.1 (2021-08-10)
# Platform: x86_64-apple-darwin17.0 (64-bit)
# Running under: macOS Monterey 12.2.1
# 
# # RStudio
# RStudio.Version()
# 
# $mode
# [1] "desktop"
# 
# $version
# [1] ‘2021.9.0.351’
# 
# $long_version
# [1] "2021.09.0+351"
# 
# $release_name
# [1] "Ghost Orchid"

##### Load packages ####

remove(list=ls())

if (!require("pacman")) install.packages("pacman")

p_load(rio, here, tidyverse, skimr, panelr, ggpubr, corrplot, corrr, xtable, 
       stargazer, knitr, huxtable, jtools, lavaan, semPlot, plm, haven, lmtest, lfe, ggExtra, modelsummary,
       patchwork, tidySEM, parameters, viridis)

source("http://andy.egge.rs/code/xtsumR.R") # xtsumR function

here() # just check the top directory 

##### Import data sets #####

# NB: this won't run as we can't supply the replication data. 
# Please contact the author(s). 

bes <- import(here("data", "BES.dta"))
shp <- import(here("data",  "shp.dta"))
liss <- import(here("data", "liss.dta"))
gles <- import(here("data", "GLES.dta"))
usvsg <- import(here("data", "US_VSG.dta"))
usyp <- import(here("data", "US_Panel.dta"))

##### Run the analysis files

source(here("code", "analysis1_code.R"))
source(here("code", "analysis2_code.R"))
source(here("code", "appendix_final.R"))


