# ---- Appendix  -----

# ---- Appendix A ----

## A1
# Summary statistics 

bes %>% select(Trust = trustMPs, Age = age, Education = edu3, "Work status" = workstatus, 
               Income = income10, "Left-Right" = leftright, "Political interest" = polint, Sex = gender) %>%
  datasummary_skim(output = "latex", title = "Summary statistics: BES")

liss %>% select(Trust = confpolt, Age = age, Education = edu3, "Work status" = workstatus, 
                Income = income10, "Left-Right" = leftright, "Political interest" = polint, Sex = gender) %>%
  datasummary_skim(output = "latex", title = "Summary statistics: LISS")

shp %>% select(Trust = pp04, Age = age, Education = edu3, "Work status" = workstatus, 
               Income = income10, "Left-Right" = leftright, "Political interest" = polint, Sex = gender) %>%
  datasummary_skim(output = "latex", title = "Summary statistics: SHP")

## A2

# Within-between variation in trust 

variance_liss <- xtsumR(liss$confpolt, liss$id)
variance_bes <- xtsumR(bes$trustMPs, bes$id)
variance_shp <- xtsumR(shp$pp04, shp$id)

# bind and change first column 
var_all <- rbind(variance_liss, variance_bes, variance_shp)
var_all[1,1] <- "LISS"
var_all[4,1] <- "BES"
var_all[7,1] <- "SHP"
var_all <- xtable(var_all)
print(var_all, include.rownames=F, file = here("tables", "wbsumstats.tex"))

var_all[2,4]/var_all[1,4] # 87% LISS variation is between
var_all[5,4]/var_all[4,4] # 87%  BESvariation is between
var_all[8,4]/var_all[7,4] # 91%  SHP variation is between

# Within-between variation in education and income

variance_liss_educ <- xtsumR(liss$edu3, liss$id)
variance_bes_educ <- xtsumR(bes$edu3, bes$id)
variance_shp_educ <- xtsumR(shp$edu3, shp$id)

var_all_educ <- rbind(variance_liss_educ, variance_bes_educ, variance_shp_educ)
var_all_educ[1,1] <- "LISS"
var_all_educ[4,1] <- "BES"
var_all_educ[7,1] <- "SHP"
var_all_educ <- xtable(var_all_educ)
print(var_all_educ, include.rownames=F, file = here("tables", "wbsumstatseduc.tex"))

variance_liss_inc <- xtsumR(liss$income10, liss$id)
variance_bes_inc <- xtsumR(bes$income10, bes$id)
variance_shp_inc <- xtsumR(shp$income10, shp$id)

var_all_inc <- rbind(variance_liss_inc, variance_bes_inc, variance_shp_inc)
var_all_inc[1,1] <- "LISS"
var_all_inc[4,1] <- "BES"
var_all_inc[7,1] <- "SHP"
var_all_inc <- xtable(var_all_inc)
print(var_all_inc, include.rownames=F, file = here("tables", "wbsumstatsinc.tex"))

# ---- Appendix B ----

## B1: Trust across waves

# gles
gles_wide <- gles %>% 
  select(id, trust_parl, month) %>% 
  spread(key = month, value = trust_parl) %>% 
  ungroup() %>% # needs this otherwise keeps the id
  select(-id)

cor(gles_wide, use = "pairwise.complete.obs") %>%
  kable(., booktabs=T, format = "latex",  caption = "Correlations across waves: GLES", digits = 2)

gles_cor <- cor(gles_wide, use = "pairwise.complete.obs")

corrplotgles <- corrplot(gles_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                         addCoef.col = "black")

png(file = here("figures", "gles_corr.png"), width = 1920, height = 1080, res = 200)
corrplotgles <-  corrplot(gles_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                          addCoef.col = "black")
dev.off()

correlation <-  gles_cor[5,] # get just first wave correlated with each subsequent wave
month <- c(1, 5, 8, 10, 10.5, 11, 12, 12.5, 13, 18, 26, 32, 38, 43, 48) # add month column
panel <- "GLES"
gles_corw1 <- data.frame(correlation, month, panel) # make into DF
ggplot(gles_corw1, aes(month, correlation)) + geom_point() # plot

# shp
shp_wide <- shp %>% 
  select(id, pp04, month) %>% 
  spread(key = month, value = pp04) %>% 
  ungroup() %>% # needs this otherwise keeps the id
  select(-id)

cor(shp_wide, use = "pairwise.complete.obs") %>%
  kable(., booktabs=T, format = "latex", caption = "Correlations across waves: SHP", digits = 2)

shp_cor <- cor(shp_wide, use = "pairwise.complete.obs")

png(file = here("figures", "shp_corr.png"), width = 1920, height = 1080, res = 200)

corrplotshp <- corrplot(shp_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                        addCoef.col = "black")
dev.off()

correlation <-  shp_cor[1,] # get just first wave correlated with each subsequent wave
month <- c(1, 13, 25, 37, 49, 61, 73, 85, 97, 109, 121, 133, 145, 157, 169, 181, 193, 205, 217, 229) # add month column
panel <- "SHP"
shp_corw1 <- data.frame(correlation, month, panel) # make into DF
ggplot(shp_corw1, aes(month, correlation)) + geom_point() # plot

# liss 
liss_wide <- liss %>% 
  select(id, confpolt, month) %>% 
  spread(key = month, value = confpolt) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

cor(liss_wide, use = "complete.obs") %>%
  kable(., booktabs=T, format = "latex", caption = "Correlations across waves: LISS", digits = 2) 

liss_cor <- cor(liss_wide, use = "pairwise.complete.obs")

png(file = here("figures", "liss_corr.png"), width = 1920, height = 1080, res = 200)

corrplotliss <- corrplot(liss_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                         addCoef.col = "black")

dev.off()

#network_plot(correlate(liss_cor), min_cor=0.2, curved=F)
# just first wave and subsequent waves
correlation <-  liss_cor[1,] # get just first wave correlated with each subsequent wave
month <- c(1, 13, 25, 37, 49, 61, 73, 97, 109, 121, 133, 145) # add wave column
panel <- "LISS"
liss_corw1 <- data.frame(correlation, month, panel) # make into DF
ggplot(liss_corw1, aes(month, correlation)) + geom_point() # plot

# bes

bes_wide <- bes %>% 
  select(id, trustMPs, month) %>% 
  spread(key = month, value = trustMPs) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

cor(bes_wide, use = "pairwise.complete.obs") %>%
  kable(., booktabs=T, format = "latex", caption = "Correlations across waves: BES", digits = 2) 

bes_cor <- cor(bes_wide, use = "pairwise.complete.obs")

png(file = here("figures", "bes_corr.png"), width = 1920, height = 1080, res = 200)
corrplotbes <-  corrplot(bes_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                         addCoef.col = "black")
dev.off()

correlation <-  bes_cor[1,] # get just first wave correlated with each subsequent wave
month <- c(1, 4, 8, 14, 15, 16, 27, 28, 29, 34, 39, 40, 41, 52, 62, 64, 70, 70.5, 71, 77) # add wave column
panel <- "BES"
bes_corw1 <- data.frame(correlation, month, panel) # make into DF
ggplot(bes_corw1, aes(month, correlation)) + geom_point() # plot

# USVSG 

usvsg <- usvsg %>% select (trustgovt_2016, trustgovt_2017, trustgovt_2018, trustgovt_2019 )

cor(usvsg, use = "pairwise.complete.obs") %>%
  kable(., booktabs=T, format = "latex", caption = "Correlations across waves: USVSG", digits = 2) 

usvsg_cor <- cor(usvsg, use = "pairwise.complete.obs")

corrplotusvsg <-  corrplot(usvsg2_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                           addCoef.col = "black")

png(file = here("figures", "usvsg_corr.png"), width = 1920, height = 1080, res = 200)
corrplotusvsg <-  corrplot(usvsg_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                           addCoef.col = "black")
dev.off()

correlation <-  usvsg_cor[1,] # get just first wave correlated with each subsequent wave
month <- c(1, 7, 17, 24) # add wave column
panel <- "USVSG"
usvsg_corw1 <- data.frame(correlation, month, panel) # make into DF

ggplot(usvsg_corw1, aes(month, correlation)) +
  geom_point() +
  geom_smooth(method = "lm", se = T)


# USYP

usyp <- usyp %>% select(trust65, trust82, trust97)

cor(usyp, use = "pairwise.complete.obs") %>%
  kable(., booktabs=T, format = "latex", caption = "Correlations across waves: USYP", digits = 2) 

usyp_cor <- cor(usyp, use = "pairwise.complete.obs")

corrplotusyp <-  corrplot(usyp_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                          addCoef.col = "black")

test <- rcorr(as.matrix(usyp))

png(file = here("figures", "usyp_corr.png"), width = 1920, height = 1080, res = 200)
corrplotusyp <-  corrplot(usyp_cor, method="color", type = "upper", tl.col="black", diag = FALSE, addCoefasPercent = T,
                          addCoef.col = "black")
dev.off()

correlation <-  usyp_cor[1,] # get just first wave correlated with each subsequent wave
month <- c(1, 204, 384) # add month column
panel <- "USYP"
usyp_corw1 <- data.frame(correlation, month, panel) # make into DF

ggplot(usyp_corw1, aes(month, correlation)) +
  geom_point() +
  geom_smooth(method = "lm", se = T)

# Merge 

firstwcorr <- rbind(bes_corw1, liss_corw1, shp_corw1, gles_corw1, usyp_corw1, usvsg_corw1)
firstwcorr <- firstwcorr %>% 
  filter(month != 1) %>%  # remove first wave 
  filter(month != 10.5) # and the first wave for GLES

ggplot(firstwcorr, aes(month, correlation, colour=factor(panel), size=correlation)) + 
  geom_point() +
  geom_smooth(method = "lm", se = T) +
  labs(
    x = "Month since first wave",
    colour = "Panel",
    size = "Correlation") +
  theme_minimal() + 
  theme(axis.ticks.y = element_blank(),
        axis.title.y = element_blank(),
        axis.text.y = element_blank())

## B2: Interest across waves


liss_int_wide <- liss %>% 
  select(id, polint, month) %>% 
  spread(key = month, value = polint) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

liss_int_corr <- cor(liss_int_wide, use = "pairwise.complete.obs") %>%
  kable(., booktabs=T, format = "latex", caption = "Political interest correlations across waves: LISS", digits = 2) 

bes_int_wide <- bes %>% 
  select(id, polint, month) %>% 
  spread(key = month, value = polint) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

bes_int_corr <- cor(bes_int_wide, use = "pairwise.complete.obs") %>%
  kable(., booktabs=T, format = "latex", caption = "Political interest correlations across waves: BES", digits = 2) 

shp_int_wide <- shp %>% 
  select(id, polint, month) %>% 
  spread(key = month, value = polint) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

shp_int_corr <- cor(shp_int_wide, use = "pairwise.complete.obs") %>%
  kable(., booktabs=T, format = "latex", caption = "Political interest correlations across waves: SHP", digits = 2) 

## B3: Correlations across time of different objects of trust


liss_wide_gov <- liss %>% 
  select(id, time, confgov) %>% 
  spread(key = time, value = c(confgov)) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

liss_cor_gov <- cor(liss_wide_gov, use = "pairwise.complete.obs")

liss_wide_part <- liss %>% 
  select(id, time, confpolpart) %>% 
  spread(key = time, value = c(confpolpart)) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

liss_cor_part <- cor(liss_wide_part, use = "pairwise.complete.obs")

liss_wide_ep <- liss %>% 
  select(id, time, confep) %>% 
  spread(key = time, value = c(confep)) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

liss_cor_ep <- cor(liss_wide_ep, use = "pairwise.complete.obs")

liss_wide_polt <- liss %>% 
  select(id, time, confpolt) %>% 
  spread(key = time, value = confpolt) %>% 
  ungroup() %>% # needs this otherwise keeps the idpers
  select(-id)

liss_cor_polt <- cor(liss_wide_polt, use = "pairwise.complete.obs")

LISS_Politicians <- liss_cor_polt[1,]
LISS_Government <- liss_cor_gov[1,]
LISS_Parties <- liss_cor_part[1,]
LISS_EP <- liss_cor_ep[1,]
wave <- 1:12

liss_cor_otherconf <- data.frame(LISS_Politicians,LISS_Government,LISS_Parties, LISS_EP, wave) # make into DF

liss_cor_otherconf <- liss_cor_otherconf %>% 
  filter(wave != 1) # remove first wave 

liss_cor_otherconf %>% tidyr::gather("id", "value", 1:4) %>% 
  ggplot(., aes(wave, value, colour = id, size=value))+
  geom_point() +
  labs(title = "Correlation between the first wave and subsequent waves for different confidence variables",
       subtitle = "Panel: LISS",
       x = "Wave number",
       colour = "Variable",
       size = "Correlation") +
  theme_minimal()

ggsave("lisscorrelations.png", 
       path = here("figures"))

# ---- Appendix C ----

## Mean change by age in the SHP

# Aged 16

shp_age <- shp %>% 
  mutate(youth = case_when(
    wave == 1 & age <16 ~ "Under 16",
    TRUE ~ "Over 16"
  )) %>% select(id, pp04, month, youth) %>% 
  group_by(id) %>% 
  mutate(youth = ifelse(any(youth == "Under 16"), "Under 16", "Over 16")) %>% 
  ungroup()

shp_wideage <- shp_age %>% 
  select(id, pp04, month, youth) %>% 
  mutate(pp04 = pp04/10) %>%
  pivot_wider(names_from = month, values_from = pp04, names_glue = "{.value}_{month}") %>%   
  group_by(youth) %>%
  mutate(trw_13 = round(mean(abs(pp04_13 - pp04_1), na.rm=T),6),
         trw_25 = round(mean(abs(pp04_25 - pp04_1), na.rm=T),6),
         trw_37 = round(mean(abs(pp04_37 - pp04_1), na.rm=T),6),
         trw_49 = round(mean(abs(pp04_49 - pp04_1), na.rm=T),6),
         trw_61 = round(mean(abs(pp04_61 - pp04_1), na.rm=T),6),
         trw_73 = round(mean(abs(pp04_73 - pp04_1), na.rm=T),6),
         trw_85 = round(mean(abs(pp04_85 - pp04_1), na.rm=T),6),
         trw_97 = round(mean(abs(pp04_97 - pp04_1), na.rm=T),6),
         trw_109 = round(mean(abs(pp04_109 - pp04_1), na.rm=T),6),
         trw_121 = round(mean(abs(pp04_121 - pp04_1), na.rm=T),6),
         trw_133 = round(mean(abs(pp04_133 - pp04_1), na.rm=T),6),
         trw_145 = round(mean(abs(pp04_145 - pp04_1), na.rm=T),6),
         trw_157 = round(mean(abs(pp04_157 - pp04_1), na.rm=T),6),
         trw_169 = round(mean(abs(pp04_169 - pp04_1), na.rm=T),6),
         trw_181 = round(mean(abs(pp04_181 - pp04_1), na.rm=T),6),
         trw_193 = round(mean(abs(pp04_193 - pp04_1), na.rm=T),6),
         trw_205 = round(mean(abs(pp04_205 - pp04_1), na.rm=T),6),
         trw_217 = round(mean(abs(pp04_217 - pp04_1), na.rm=T),6),
         trw_229 = round(mean(abs(pp04_229 - pp04_1), na.rm=T),6),
  ) %>% ungroup()

shp_long <- shp_wideage %>%
  group_by(youth) %>%
  select(trw_13:trw_229) %>%
  pivot_longer(
    cols = trw_13:trw_229,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )

shp_long$month <- as.numeric(shp_long$month)
shp_mean16 <- as.data.frame(shp_long) %>% group_by(month, youth) %>% summarise(mean = mean(mean))

ggplot(shp_mean, aes(month, mean, colour=factor(youth))) + 
  geom_point() +
  theme_minimal() +
  geom_smooth(method = "lm", se = F)

# Aged 20

shp_age <- shp %>% 
  mutate(youth = case_when(
    wave == 1 & age <20 ~ "Under 20",
    TRUE ~ "Over 20"
  )) %>% select(id, pp04, month, youth) %>% 
  group_by(id) %>% 
  mutate(youth = ifelse(any(youth == "Under 20"), "Under 20", "Over 20")) %>% 
  ungroup()

shp_wideage <- shp_age %>% 
  select(id, pp04, month, youth) %>% 
  mutate(pp04 = pp04/10) %>%
  pivot_wider(names_from = month, values_from = pp04, names_glue = "{.value}_{month}") %>%   
  group_by(youth) %>%
  mutate(trw_13 = round(mean(abs(pp04_13 - pp04_1), na.rm=T),6),
         trw_25 = round(mean(abs(pp04_25 - pp04_1), na.rm=T),6),
         trw_37 = round(mean(abs(pp04_37 - pp04_1), na.rm=T),6),
         trw_49 = round(mean(abs(pp04_49 - pp04_1), na.rm=T),6),
         trw_61 = round(mean(abs(pp04_61 - pp04_1), na.rm=T),6),
         trw_73 = round(mean(abs(pp04_73 - pp04_1), na.rm=T),6),
         trw_85 = round(mean(abs(pp04_85 - pp04_1), na.rm=T),6),
         trw_97 = round(mean(abs(pp04_97 - pp04_1), na.rm=T),6),
         trw_109 = round(mean(abs(pp04_109 - pp04_1), na.rm=T),6),
         trw_121 = round(mean(abs(pp04_121 - pp04_1), na.rm=T),6),
         trw_133 = round(mean(abs(pp04_133 - pp04_1), na.rm=T),6),
         trw_145 = round(mean(abs(pp04_145 - pp04_1), na.rm=T),6),
         trw_157 = round(mean(abs(pp04_157 - pp04_1), na.rm=T),6),
         trw_169 = round(mean(abs(pp04_169 - pp04_1), na.rm=T),6),
         trw_181 = round(mean(abs(pp04_181 - pp04_1), na.rm=T),6),
         trw_193 = round(mean(abs(pp04_193 - pp04_1), na.rm=T),6),
         trw_205 = round(mean(abs(pp04_205 - pp04_1), na.rm=T),6),
         trw_217 = round(mean(abs(pp04_217 - pp04_1), na.rm=T),6),
         trw_229 = round(mean(abs(pp04_229 - pp04_1), na.rm=T),6),
  ) %>% ungroup()

shp_long <- shp_wideage %>%
  group_by(youth) %>%
  select(trw_13:trw_229) %>%
  pivot_longer(
    cols = trw_13:trw_229,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )
shp_long$month <- as.numeric(shp_long$month)
shp_mean20 <- as.data.frame(shp_long) %>% group_by(month, youth) %>% summarise(mean = mean(mean))

ggplot(shp_mean, aes(month, mean, colour=factor(youth))) + 
  geom_point() +
  theme_minimal() +
  geom_smooth(method = "lm", se = F)

# Aged 25

shp_age <- shp %>% 
  mutate(youth = case_when(
    wave == 1 & age <25 ~ "Under 25",
    TRUE ~ "Over 25"
  )) %>% select(id, pp04, month, youth) %>% 
  group_by(id) %>% 
  mutate(youth = ifelse(any(youth == "Under 25"), "Under 25", "Over 25")) %>% 
  ungroup()

shp_wideage <- shp_age %>% 
  select(id, pp04, month, youth) %>% 
  mutate(pp04 = pp04/10) %>%
  pivot_wider(names_from = month, values_from = pp04, names_glue = "{.value}_{month}") %>%   
  group_by(youth) %>%
  mutate(trw_13 = round(mean(abs(pp04_13 - pp04_1), na.rm=T),6),
         trw_25 = round(mean(abs(pp04_25 - pp04_1), na.rm=T),6),
         trw_37 = round(mean(abs(pp04_37 - pp04_1), na.rm=T),6),
         trw_49 = round(mean(abs(pp04_49 - pp04_1), na.rm=T),6),
         trw_61 = round(mean(abs(pp04_61 - pp04_1), na.rm=T),6),
         trw_73 = round(mean(abs(pp04_73 - pp04_1), na.rm=T),6),
         trw_85 = round(mean(abs(pp04_85 - pp04_1), na.rm=T),6),
         trw_97 = round(mean(abs(pp04_97 - pp04_1), na.rm=T),6),
         trw_109 = round(mean(abs(pp04_109 - pp04_1), na.rm=T),6),
         trw_121 = round(mean(abs(pp04_121 - pp04_1), na.rm=T),6),
         trw_133 = round(mean(abs(pp04_133 - pp04_1), na.rm=T),6),
         trw_145 = round(mean(abs(pp04_145 - pp04_1), na.rm=T),6),
         trw_157 = round(mean(abs(pp04_157 - pp04_1), na.rm=T),6),
         trw_169 = round(mean(abs(pp04_169 - pp04_1), na.rm=T),6),
         trw_181 = round(mean(abs(pp04_181 - pp04_1), na.rm=T),6),
         trw_193 = round(mean(abs(pp04_193 - pp04_1), na.rm=T),6),
         trw_205 = round(mean(abs(pp04_205 - pp04_1), na.rm=T),6),
         trw_217 = round(mean(abs(pp04_217 - pp04_1), na.rm=T),6),
         trw_229 = round(mean(abs(pp04_229 - pp04_1), na.rm=T),6),
  ) %>% ungroup()

shp_long <- shp_wideage %>%
  group_by(youth) %>%
  select(trw_13:trw_229) %>%
  pivot_longer(
    cols = trw_13:trw_229,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )
shp_long$month <- as.numeric(shp_long$month)
shp_mean25 <- as.data.frame(shp_long) %>% group_by(month, youth) %>% summarise(mean = mean(mean))

shp_mean <- rbind(shp_mean16, shp_mean20, shp_mean25)

ggplot(shp_mean, aes(month, mean, colour=factor(youth))) + 
  geom_point() +
  theme_minimal() +
  geom_smooth(method = "lm", se = F) +
  labs(y = "Average change since first wave (scaled 0-1)",
       x = "Month from first wave",
       colour = "Age in first wave") +
  guides(color = guide_legend(reverse = TRUE))

# ---- Appendix D -----

## Latent growth models

liss_lgcdf <- panel_data(comp_liss, id = id, wave = wave)
bes_lgcdf <- panel_data(comp_bes, id = id, wave = wave)
shp_lgcdf <- panel_data(comp_shp, id = id, wave = wave)
gles_lgcdf <- panel_data(comp_gles, id=id, wave=wave)

## LISS 

liss_mm_df <- liss_lgcdf %>% 
  select(id, wave, confpolt, confep, confgov, confparl)

liss_mm_df <-  widen_panel(liss_mm_df, separator = "_")

model <- 'i =~ 1*confpolt_1 + 1*confpolt_2 + 1*confpolt_3 + 1*confpolt_4 +
                1*confpolt_5 + 1*confpolt_6 + 1*confpolt_7 + 1*confpolt_8 +
                1*confpolt_9 + 1*confpolt_10 + 1*confpolt_11 + 1*confpolt_12
          s =~ 1*confpolt_1 + 2*confpolt_2 + 3*confpolt_3 + 4*confpolt_4 +
                5*confpolt_5 + 6*confpolt_6 + 7*confpolt_7 + 8*confpolt_8 +
                9*confpolt_9 + 10*confpolt_10 + 11*confpolt_11 + 12*confpolt_12'

fit_lgm <- growth(model, data = liss_mm_df)

summary(fit_lgm, standardized = TRUE)

library(tidySEM)
graph_sem(model = fit_lgm)

pred_lgm <- predict(fit_lgm)

pred_lgm_long <- map(1:10, 
                     function(x) pred_lgm[, 1] + x * pred_lgm[, 2]) %>% 
  reduce(cbind) %>% 
  as.data.frame() %>%
  setNames(str_c("Wave", 1:10)) %>% 
  mutate(id = row_number()) %>% 
  gather(-id, key = wave, value = pred)

pred_lgm_long$wave <- as.factor(pred_lgm_long$wave)

pred_lgm_long$wave <- fct_relevel(pred_lgm_long$wave, "Wave10", "Wave11", "Wave12", 
                                  "Wave13", "Wave14", "Wave15",
                                  "Wave16", "Wave17", "Wave18",
                                  "Wave19", "Wave20", 
                                  after = Inf)

lgc_liss <- pred_lgm_long %>% 
  ggplot(aes(wave, pred, group = id)) + # what variables to plot?
  geom_line(alpha = 0.05) + # add a transparent line for each person
  stat_summary( # add average line
    aes(group = 1),
    fun = mean,
    geom = "line",
    size = 1.5,
    color = "red"
  ) +
  theme_minimal() + # makes graph look nicer
  labs(y = "Trust",
       x = "", # labels
       title = "LISS") +   scale_x_discrete(guide = guide_axis(check.overlap = TRUE))


ggsave("lgc_liss.png", 
       path = here("figures"))

## BES

bes_mm_df <- bes_lgcdf %>% 
  select(id, wave, trustMPs) %>%
  filter(wave <12)

bes_mm_df <- widen_panel(bes_mm_df, separator = "_")

model <- 'i =~ 1*trustMPs_1 + 1*trustMPs_2 + 1*trustMPs_3 + 1*trustMPs_4 +
                 + 1*trustMPs_6 + 1*trustMPs_7 + 1*trustMPs_8 +
                1*trustMPs_9 + 1*trustMPs_10
          s =~ 1*trustMPs_1 + 2*trustMPs_2 + 3*trustMPs_3 + 4*trustMPs_4 + 6*trustMPs_6 + 7*trustMPs_7 + 8*trustMPs_8 +
                9*trustMPs_9 + 10*trustMPs_10'

fit_lgm <- growth(model, data = bes_mm_df)

summary(fit_lgm, standardized = TRUE)

pred_lgm <- predict(fit_lgm)

pred_lgm_long <- map(1:10, 
                     function(x) pred_lgm[, 1] + x * pred_lgm[, 2]) %>% 
  reduce(cbind) %>% 
  as.data.frame() %>%
  setNames(str_c("Wave", 1:10)) %>% 
  mutate(id = row_number()) %>% 
  gather(-id, key = wave, value = pred)

pred_lgm_long$wave <- as.factor(pred_lgm_long$wave)

pred_lgm_long$wave <- fct_relevel(pred_lgm_long$wave, "Wave10", "Wave11", "Wave12", 
                                  "Wave13", "Wave14", "Wave15",
                                  "Wave16", "Wave17", "Wave18",
                                  "Wave19", "Wave20", 
                                  after = Inf)


lgc_bes <- pred_lgm_long %>% 
  ggplot(aes(wave, pred, group = id)) + # what variables to plot?
  geom_line(alpha = 0.05) + # add a transparent line for each person
  stat_summary( # add average line
    aes(group = 1),
    fun = mean,
    geom = "line",
    size = 1.5,
    color = "red"
  ) +
  theme_minimal() + # makes graph look nicer
  labs( y = "", # labels
        x = "Wave",
        title = "BES") +   scale_x_discrete(guide = guide_axis(check.overlap = TRUE))


ggsave("lgc_bes.png", 
       path = here("figures"))
## SHP

shp_mm_df <- shp_lgcdf %>% 
  select(id, wave, pp04) 

shp_mm_df<- widen_panel(shp_mm_df, separator = "_")

model <- 'i =~ 1*pp04_1 + 1*pp04_2 + 1*pp04_3 + 1*pp04_4 + 1*pp04_5 +
                 + 1*pp04_6 + 1*pp04_7 + 1*pp04_8 +
                1*pp04_9 + 1*pp04_10 + 1*pp04_11 + 1*pp04_13 +
                1*pp04_16 + 1*pp04_19 
          s =~ 1*pp04_1 + 2*pp04_2 + 3*pp04_3 + 4*pp04_4 + 5*pp04_5 +
                 + 6*pp04_6 + 7*pp04_7 + 8*pp04_8 +
                9*pp04_9 + 10*pp04_10 + 11*pp04_11 + 13*pp04_13 +
                16*pp04_16 + 19*pp04_19'

fit_lgm <- growth(model, data = shp_mm_df)

summary(fit_lgm, standardized = TRUE)

pred_lgm <- predict(fit_lgm)

pred_lgm_long <- map(1:20, 
                     function(x) pred_lgm[, 1] + x * pred_lgm[, 2]) %>% 
  reduce(cbind) %>% 
  as.data.frame() %>%
  setNames(str_c("Wave", 1:20)) %>% 
  mutate(id = row_number()) %>% 
  gather(-id, key = wave, value = pred)

pred_lgm_long$wave <- as.factor(pred_lgm_long$wave)

pred_lgm_long$wave <- fct_relevel(pred_lgm_long$wave, "Wave10", "Wave11", "Wave12", 
                                  "Wave13", "Wave14", "Wave15",
                                  "Wave16", "Wave17", "Wave18",
                                  "Wave19", "Wave20", 
                                  after = Inf)

lgc_shp <- pred_lgm_long %>% 
  ggplot(aes(as.factor(wave), pred, group = id)) + # what variables to plot?
  geom_line(alpha = 0.03) + # add a transparent line for each person
  stat_summary( # add average line
    aes(group = 1),
    fun = mean,
    geom = "line",
    size = 1,
    color = "red"
  ) +
  theme_minimal() + # makes graph look nicer
  labs( # labels
    x = "",
    y = "",
    title = "SHP") +
  scale_x_discrete(guide = guide_axis(check.overlap = TRUE))

ggsave("lgc_shp.png", 
       path = here("figures"))

lgc_liss + lgc_bes + lgc_shp

ggsave("lgc_merged.png", 
       path = here("figures"))  

# ---- Appendix E -----
# Remake the data to be sure
comp_liss <- liss %>% filter(confpolt != "NA") %>% group_by(id) %>% mutate(count=n()) %>% filter(count>=12) %>% ungroup()
comp_bes <- bes %>% filter(trustMPs != "NA") %>% group_by(id) %>% mutate(count=n()) %>% filter(count >= 13) %>% ungroup()
comp_shp <- shp %>% filter(pp04 != "NA") %>% group_by(id)  %>% mutate(count=n()) %>% filter(count>=10) %>% ungroup()

# Change to factor variables 

comp_liss <- comp_liss %>% mutate(
  workstatus = factor(workstatus, levels = c(1, 2, 3, 4)),
  edu3 = factor(edu3, levels = c(1, 2, 3)),
  polint = factor(polint, levels = c(1, 2, 3)))

comp_bes <- comp_bes %>% mutate(
  workstatus = factor(workstatus, levels = c(1, 2, 3, 4)),
  edu3 = factor(edu3, levels = c(1, 2, 3)),
  polint = factor(polint, levels = c(1, 2, 3)))

comp_shp <- comp_shp %>% mutate(
  workstatus = factor(workstatus, levels = c(1, 2, 3, 4)),
  edu3 = factor(edu3, levels = c(1, 2, 3)),
  polint = factor(polint, levels = c(1, 2, 3)))

## Make the 0-1 variables
comp_bes <- comp_bes %>%
  mutate(trustMPs = (trustMPs-1)/6)

comp_liss<- comp_liss %>%
  mutate(confpolt = confpolt/10)

comp_shp <- comp_shp %>%
  mutate(pp04 = pp04/10)

## Pooled with clustered errors

liss_pooled_cl <-   felm(confpolt ~ age + edu3 + workstatus + income10 + leftright + polint + gender | 0 | 0 | id +wave, 
                         data=comp_liss)
bes_pooled_cl <-   felm(trustMPs ~ age + edu3 + workstatus + income10 + leftright + polint + gender | 0 | 0 | id + wave, 
                        data=comp_bes)
shp_pooled_cl <-   felm(pp04 ~ age + edu3 + workstatus + income10 + leftright + polint + gender | 0 | 0 | id + idhous + wave, 
                        data=comp_shp)

#stargazer(liss_pooled_cl, bes_pooled_cl, shp_pooled_cl, type = "text")

# stargazer(liss_pooled_cl, shp_pooled_cl, bes_pooled_cl, model.names = FALSE, model.numbers = NULL,
#           header=FALSE, dep.var.caption = "Political trust", dep.var.labels.include = FALSE,
#           covariate.labels = c("Age", "Education: Medium", "Education: University" , "Work status: Student", 
#                                "Work status: Retired", "Work status: Unemployed/Other", "Income", 
#                                "Left right", "Political interest: Fairly interested",  "Political interest: Very interested",
#                                "Female"),
#           column.labels=c("LISS", "SHP", "BES"),
#           no.space = TRUE, notes = "Standard errors clustered by individual and wave", notes.append = T,
#           title = "Pooled OLS models predicting political trust",
#           label = "lab:pooledols",
#           keep.stat =c("n","rsq"))

## FE models

liss_pooled_fe <-   felm(confpolt ~ age + edu3 + workstatus + income10 + leftright + polint  | id | 0 | wave, 
                         data=comp_liss)
bes_pooled_fe <-   felm(trustMPs ~ age + edu3 + workstatus + income10 + leftright + polint  | id | 0 | wave, 
                        data=comp_bes)
shp_pooled_fe <-   felm(pp04 ~ age + edu3 + workstatus + income10 + leftright + polint   | id+idhous | 0 | wave, 
                        data=comp_shp)

stargazer(liss_pooled_cl, shp_pooled_cl, bes_pooled_cl, liss_pooled_fe, shp_pooled_fe, bes_pooled_fe,
          model.names = FALSE, model.numbers = NULL,
          header=FALSE, dep.var.caption = "Political trust", dep.var.labels.include = FALSE,
          covariate.labels = c("Age", "Education: Medium", "Education: University" , "Work status: Student", 
                               "Work status: Retired", "Work status: Unemployed/Other", "Income", 
                               "Left right", "Political interest: Fairly interested",  "Political interest: Very interested",
                               "Female"),         
          column.labels=c("LISS", "SHP", "BES", "LISS (FEs)", "SHP (FEs)", "BES (FEs)"),
          no.space = TRUE, notes = "Cols 1-3, Standard errors clustered by individual and wave; \n Cols 4-6 fixed effects", notes.append = T,
          title = "Pooled and fixed-effects OLS models predicting political trust",
          label = "tab:pooledolsfe",
          keep.stat =c("n","rsq"))

## Removing the random slope on time
# Demean them for the WBM 

d_liss <- cbind(
  comp_liss,
  demean(comp_liss, select = c("income10", "edu3", 
                               "workstatus", "leftright",
                               "polint", "age"), group = "id") # from package "parameters"
)

d_shp <- cbind(
  comp_shp,
  demean(comp_shp, select = c("income10", "edu3", 
                              "workstatus", "leftright",
                              "polint", "age"), group = "id") # from package "parameters"
)

d_bes <- cbind(
  comp_bes,
  demean(comp_bes, select = c("income10", "edu3", 
                              "workstatus", "leftright",
                              "polint", "age"), group = "id") # from package "parameters"
)

model_rewb_liss_nrs <- lmer( 
  confpolt ~ age_within + age_between + 
    income10_within + income10_between + 
    edu3_2_within + edu3_2_between +
    edu3_3_within + edu3_3_between + 
    workstatus_2_within + workstatus_2_between +
    workstatus_3_within + workstatus_3_between +
    workstatus_4_within + workstatus_4_between +
    leftright_within + leftright_between + 
    polint_2_within + polint_2_between +
    polint_3_within + polint_3_between +
    gender + wave +
    (1 | id),
  data = d_liss,
  control = lmerControl(check.nobs.vs.nRE = "ignore")
)

model_rewb_shp_nrs <- lmer(
  pp04 ~ age_within + age_between + 
    income10_within + income10_between + 
    edu3_2_within + edu3_2_between +
    edu3_3_within + edu3_3_between + 
    workstatus_2_within + workstatus_2_between +
    workstatus_3_within + workstatus_3_between +
    workstatus_4_within + workstatus_4_between +
    leftright_within + leftright_between + 
    polint_2_within + polint_2_between +
    polint_3_within + polint_3_between +
    gender + wave +
    (1 | id) + (1|idhous),
  data = d_shp,
  control = lmerControl(check.nobs.vs.nRE = "ignore")
)

model_rewb_bes_nrs <- lmer(
  trustMPs ~ age_within + age_between + 
    income10_within + income10_between + 
    edu3_2_within + edu3_2_between +
    edu3_3_within + edu3_3_between + 
    workstatus_2_within + workstatus_2_between +
    workstatus_3_within + workstatus_3_between +
    workstatus_4_within + workstatus_4_between +
    leftright_within + leftright_between + 
    polint_2_within + polint_2_between +
    polint_3_within + polint_3_between +
    gender + wave +
    (1  |id),
  data = d_bes,
  control = lmerControl(check.nobs.vs.nRE = "ignore")
)

anova(model_rewb_bes, model_rewb_bes_nrs)
anova(model_rewb_shp, model_rewb_shp_nrs)
anova(model_rewb_liss, model_rewb_liss_nrs)

stargazer(model_rewb_liss, model_rewb_shp, model_rewb_bes, model_rewb_liss_nrs, model_rewb_shp_nrs, model_rewb_bes_nrs,
          model.names = FALSE, model.numbers = NULL,
          header=FALSE, dep.var.caption = "Political trust", dep.var.labels.include = FALSE,
          covariate.labels = c("Age: Within", "Age: Between", "Income: Within", "Income: Between",
                               "Medium Educ: Within","Medium Educ: Between", "University: Within", 
                               "University: Between", "Student: Within", "Student: Between",
                               "Retired; Within", "Retired: Between", "Unemployed; Within", "Unemployed: Between", 
                               "Left-right: Within", "Left-right: Between",
                               "Fairly interested: Within", "Fairly Interested: Between", "Very interested: Within", 
                               "Very Interested: Between",
                               "Sex", "Wave"),         
          column.labels=c("LISS", "SHP", "BES", "LISS", "SHP", "BES"),
          no.space = TRUE, notes = "Cols 1-3, with time slope; \n Cols 4-6 without time slope", notes.append = T,
          title = "Comparing models with a random slope for time and without",
          label = "tab:modcomp",
          keep.stat =c("n","rsq"))

## Check statistical issues

# Singularity
tt <- getME(model_rewb_liss,"theta")
ll <- getME(model_rewb_liss,"lower")
min(tt[ll==0])

tt <- getME(model_rewb_shp,"theta")
ll <- getME(model_rewb_shp,"lower")
min(tt[ll==0])

tt <- getME(model_rewb_bes,"theta")
ll <- getME(model_rewb_bes,"lower")
min(tt[ll==0])

# Gradient
derivs1 <- model_rewb_liss@optinfo$derivs
sc_grad1 <- with(derivs1,solve(Hessian,gradient))
max(abs(sc_grad1))

max(pmin(abs(sc_grad1),abs(derivs1$gradient)))

derivs1 <- model_rewb_shp@optinfo$derivs
sc_grad1 <- with(derivs1,solve(Hessian,gradient))
max(abs(sc_grad1))

max(pmin(abs(sc_grad1),abs(derivs1$gradient)))

derivs1 <- model_rewb_bes@optinfo$derivs
sc_grad1 <- with(derivs1,solve(Hessian,gradient))
max(abs(sc_grad1))

max(pmin(abs(sc_grad1),abs(derivs1$gradient)))

# Optimisers 

aa <- allFit(model_rewb_liss)
is.OK <- sapply(aa,is,"merMod")  
aa.OK <- aa[is.OK]
lapply(aa.OK,function(x) x@optinfo$conv$lme4$messages)

(lliks <- sort(sapply(aa.OK,logLik))) # all loglikelihoods are the same

aa <- allFit(model_rewb_shp)
is.OK <- sapply(aa,is,"merMod")  
aa.OK <- aa[is.OK]
lapply(aa.OK,function(x) x@optinfo$conv$lme4$messages)

(lliks <- sort(sapply(aa.OK,logLik))) # all loglikelihoods are the same

aa <- allFit(model_rewb_bes)
is.OK <- sapply(aa,is,"merMod")  
aa.OK <- aa[is.OK]
lapply(aa.OK,function(x) x@optinfo$conv$lme4$messages)

(lliks <- sort(sapply(aa.OK,logLik))) # all loglikelihoods are the same

# ---- Appendix F ----

bes_brexit <- bes %>% group_by(id) %>% mutate(count=n()) %>% filter(count>1) %>% ungroup() # filter to >1 wave
n_distinct(bes_brexit$id) # 82225

bes_brexit2 <- bes %>%   mutate(refvote = case_when(Leave == 1 ~ "Leave",
                                                    Remain == 1 ~ "Remain")) %>%
  drop_na(refvote) %>% 
  group_by(refvote, wave) %>% arrange(id, wave) %>% summarise(av_trst = mean(trustMPs, na.rm=T))

ggplot(bes_brexit2, aes(x = wave, y = av_trst, colour = refvote, group = refvote)) +
  geom_line() +
  geom_point() +
  geom_vline(xintercept = 9, linetype="dashed", alpha = 0.5) +
  geom_vline(xintercept = 19, linetype="dashed", alpha = 0.5) +
  geom_vline(xintercept = 12, linetype="dashed", alpha = 0.5) +
  theme_minimal() +
  theme(legend.title=element_blank()) +
  labs(x = "Wave",
       y = "Average trust in MPs in general (0-7)",
       title = "Average trust in Members of Parliament",
       subtitle = "separated by EU Referendum vote",
       caption = "Data: British Election Study") +
  annotate("text", x = 6, y=4, label = "Referendum", 
           colour="black", fontface=2) +
  annotate("text", x = 14, y=3.75, label = "2017 GE", 
           colour="black", fontface=2) +
  annotate("text", x = 17, y=3.4, label = "2019 GE", 
           colour="black", fontface=2)

ggsave("brexitimpact.png", 
       path = here("figures"))

