# ---- Analysis 1: Attitude stability over time ----

# ----- Figure 2: Mean change between first and subsequent waves in 6 panel studies, 1965-2020 -----

bes_wide <- bes %>%
  select(id, trustMPs, month) %>%
  mutate(trustMPs = (trustMPs-1)/6) %>% 
  pivot_wider(names_from = month, 
              values_from = trustMPs,
              names_glue = "{.value}_{month}")

liss_wide <- liss %>%
  select(id, confpolt, month) %>%
  mutate(confpolt = confpolt/10) %>%
  pivot_wider(names_from = month, 
              values_from = confpolt,
              names_glue = "{.value}_{month}")

shp_wide <- shp %>%
  select(id, pp04, month) %>%
  mutate(pp04 = pp04/10) %>%
  pivot_wider(names_from = month, 
              values_from = pp04,
              names_glue = "{.value}_{month}")

gles_wide <- gles %>%
  select(id, trust_parl, month) %>%
  mutate(trust_parl = (trust_parl-1)/5) %>%
  pivot_wider(names_from = month, 
              values_from = trust_parl,
              names_glue = "{.value}_{month}")

usvsg_fig1 <- usvsg %>% select(id, trustgovt_2016, trustgovt_2017, trustgovt_2018, 
                          trustgovt_2019)  %>%
  mutate(trustgovt_2016 = (trustgovt_2016-1)/2,
         trustgovt_2017 = (trustgovt_2017-1)/2,
         trustgovt_2018 = (trustgovt_2018-1)/2,
         trustgovt_2019 = (trustgovt_2019-1)/2)

usyp_fig1 <- usyp %>% select(id, trust65, trust82, trust97) %>%
  mutate(trust65 = (trust65-1)/2,
         trust82 = (trust82-1)/2,
         trust97 = (trust97-1)/2)

# generate the mean differences 

bes_wide <- bes_wide %>%
  mutate(trw_4 = round(mean(abs(trustMPs_4 - trustMPs_1), na.rm=T),6),
         trw_8 = round(mean(abs(trustMPs_8 - trustMPs_1), na.rm=T),6),
         trw_14 = round(mean(abs(trustMPs_14 - trustMPs_1), na.rm=T),6),
         trw_15 = round(mean(abs(trustMPs_15 - trustMPs_1), na.rm=T),6),
         trw_16 = round(mean(abs(trustMPs_16 - trustMPs_1), na.rm=T),6),
         trw_27 = round(mean(abs(trustMPs_27 - trustMPs_1), na.rm=T),6),
         trw_28 = round(mean(abs(trustMPs_28 - trustMPs_1), na.rm=T),6),
         trw_29 = round(mean(abs(trustMPs_29 - trustMPs_1), na.rm=T),6),
         trw_34 = round(mean(abs(trustMPs_34 - trustMPs_1), na.rm=T),6),
         trw_39 = round(mean(abs(trustMPs_39 - trustMPs_1), na.rm=T),6),
         trw_40 = round(mean(abs(trustMPs_40 - trustMPs_1), na.rm=T),6),
         trw_41 = round(mean(abs(trustMPs_41 - trustMPs_1), na.rm=T),6),
         trw_52 = round(mean(abs(trustMPs_52 - trustMPs_1), na.rm=T),6),
         trw_62 = round(mean(abs(trustMPs_62 - trustMPs_1), na.rm=T),6),
         trw_64 = round(mean(abs(trustMPs_64 - trustMPs_1), na.rm=T),6),
         trw_70 = round(mean(abs(trustMPs_70 - trustMPs_1), na.rm=T),6),
         trw_70.5 = round(mean(abs(trustMPs_70.5 - trustMPs_1), na.rm=T),6),
         trw_71 = round(mean(abs(trustMPs_71- trustMPs_1), na.rm=T),6),
         trw_77 = round(mean(abs(trustMPs_77 - trustMPs_1), na.rm=T),6),
  )

liss_wide <- liss_wide %>%
  mutate(trw_13 = round(mean(abs(confpolt_13 - confpolt_1), na.rm=T),6),
         trw_25 = round(mean(abs(confpolt_25 - confpolt_1), na.rm=T),6),
         trw_37 = round(mean(abs(confpolt_37 - confpolt_1), na.rm=T),6),
         trw_49 = round(mean(abs(confpolt_49 - confpolt_1), na.rm=T),6),
         trw_61 = round(mean(abs(confpolt_61 - confpolt_1), na.rm=T),6),
         trw_73 = round(mean(abs(confpolt_73 - confpolt_1), na.rm=T),6),
         trw_97 = round(mean(abs(confpolt_97 - confpolt_1), na.rm=T),6),
         trw_109 = round(mean(abs(confpolt_109 - confpolt_1), na.rm=T),6),
         trw_121 = round(mean(abs(confpolt_121 - confpolt_1), na.rm=T),6),
         trw_133 = round(mean(abs(confpolt_133 - confpolt_1), na.rm=T),6),
         trw_145 = round(mean(abs(confpolt_145 - confpolt_1), na.rm=T),6)
  )

shp_wide <- shp_wide %>%
  mutate(trw_13 = round(mean(abs(pp04_13 - pp04_1), na.rm=T),6),
         trw_25 = round(mean(abs(pp04_25 - pp04_1), na.rm=T),6),
         trw_37 = round(mean(abs(pp04_37 - pp04_1), na.rm=T),6),
         trw_49 = round(mean(abs(pp04_49 - pp04_1), na.rm=T),6),
         trw_61 = round(mean(abs(pp04_61 - pp04_1), na.rm=T),6),
         trw_73 = round(mean(abs(pp04_73 - pp04_1), na.rm=T),6),
         trw_85 = round(mean(abs(pp04_85 - pp04_1), na.rm=T),6),
         trw_97 = round(mean(abs(pp04_97 - pp04_1), na.rm=T),6),
         trw_109 = round(mean(abs(pp04_109 - pp04_1), na.rm=T),6),
         trw_121 = round(mean(abs(pp04_121 - pp04_1), na.rm=T),6),
         trw_133 = round(mean(abs(pp04_133 - pp04_1), na.rm=T),6),
         trw_145 = round(mean(abs(pp04_145 - pp04_1), na.rm=T),6),
         trw_157 = round(mean(abs(pp04_157 - pp04_1), na.rm=T),6),
         trw_169 = round(mean(abs(pp04_169 - pp04_1), na.rm=T),6),
         trw_181 = round(mean(abs(pp04_181 - pp04_1), na.rm=T),6),
         trw_193 = round(mean(abs(pp04_193 - pp04_1), na.rm=T),6),
         trw_205 = round(mean(abs(pp04_205 - pp04_1), na.rm=T),6),
         trw_217 = round(mean(abs(pp04_217 - pp04_1), na.rm=T),6),
         trw_229 = round(mean(abs(pp04_229 - pp04_1), na.rm=T),6),
  )

gles_wide <- gles_wide %>%
  mutate(
    trw_8 = round(mean(abs(trust_parl_8 - trust_parl_5), na.rm=T),6),
    trw_10 = round(mean(abs(trust_parl_10 - trust_parl_5), na.rm=T),6),
    trw_10.5 = round(mean(abs(trust_parl_10.5 - trust_parl_5), na.rm=T),6),
    trw_11 = round(mean(abs(trust_parl_11 - trust_parl_5), na.rm=T),6),
    trw_12 = round(mean(abs(trust_parl_12 - trust_parl_5), na.rm=T),6),
    trw_12.5 = round(mean(abs(trust_parl_12.5 - trust_parl_5), na.rm=T),6),
    trw_13 = round(mean(abs(trust_parl_13 - trust_parl_5), na.rm=T),6),
    trw_18 = round(mean(abs(trust_parl_18 - trust_parl_5), na.rm=T),6),
    trw_26 = round(mean(abs(trust_parl_26 - trust_parl_5), na.rm=T),6),
    trw_32 = round(mean(abs(trust_parl_32 - trust_parl_5), na.rm=T),6),
    trw_38 = round(mean(abs(trust_parl_38 - trust_parl_5), na.rm=T),6),
    trw_43 = round(mean(abs(trust_parl_43 - trust_parl_5), na.rm=T),6),
    trw_48 = round(mean(abs(trust_parl_48 - trust_parl_5), na.rm=T),6)
  )

usvsg_fig1 <- usvsg_fig1 %>%
  mutate(trw_7 = round(mean(abs(trustgovt_2017 - trustgovt_2016), na.rm=T),6),
         trw_17 = round(mean(abs(trustgovt_2018 - trustgovt_2016), na.rm=T),6),
         trw_24 = round(mean(abs(trustgovt_2019 - trustgovt_2016), na.rm=T),6))

usyp_fig1 <- usyp_fig1 %>% 
  mutate(trw_204 = round(mean(abs(trust82 - trust65), na.rm=T),6),
         trw_384 = round(mean(abs(trust97 - trust65), na.rm=T),6)
  )


bes_long <- bes_wide %>%
  select(trw_4:trw_77) %>%
  pivot_longer(
    cols = trw_4:trw_77,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )

liss_long <- liss_wide %>%
  select(trw_13:trw_145) %>%
  pivot_longer(
    cols = trw_13:trw_145,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )

shp_long <- shp_wide %>%
  select(trw_13:trw_229) %>%
  pivot_longer(
    cols = trw_13:trw_229,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )

gles_long <- gles_wide %>%
  select(trw_8:trw_48) %>%
  pivot_longer(
    cols = trw_8:trw_48,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )

usyp_long <- usyp_fig1 %>%
  select(trw_204:trw_384) %>%
  pivot_longer(
    cols = trw_204:trw_384,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )

usvsg_long <- usvsg_fig1 %>%
  select(trw_7:trw_24) %>%
  pivot_longer(
    cols = trw_7:trw_24,
    names_to = c("value", "month"),
    names_sep = "_",
    values_to = "mean",
    names_repair = "unique"
  )

liss_long$month <- as.numeric(liss_long$month)
bes_long$month <- as.numeric(bes_long$month)
gles_long$month <- as.numeric(gles_long$month)
shp_long$month <- as.numeric(shp_long$month)
usvsg_long$month <- as.numeric(usvsg_long$month)
usyp_long$month <- as.numeric(usyp_long$month)

liss_mean <- as.data.frame(liss_long) %>% group_by(month) %>% summarise(mean = mean(mean))
shp_mean <- as.data.frame(shp_long) %>% group_by(month) %>% summarise(mean = mean(mean))
bes_mean <- as.data.frame(bes_long) %>% group_by(month) %>% summarise(mean = mean(mean))
gles_mean <- as.data.frame(gles_long) %>% group_by(month) %>% summarise(mean = mean(mean))
usvsg_mean <- as.data.frame(usvsg_long) %>% group_by(month) %>% summarise(mean = mean(mean))
usyp_mean <- as.data.frame(usyp_long) %>% group_by(month) %>% summarise(mean = mean(mean))

shp_mean$panel <- "SHP"

liss_mean$panel <- "LISS"

bes_mean$panel <- "BES"

gles_mean$panel <- "GLES"

usvsg_mean$panel <- "USVSG"

usyp_mean$panel <- "USYP"

graph_df <- rbind(shp_mean, liss_mean, bes_mean, gles_mean, usvsg_mean, usyp_mean)

# Figure 2:
ggplot(graph_df, aes(month, mean, colour=factor(panel), size=mean, shape = )) + 
  geom_point() +
  theme_minimal() +
  geom_smooth(method = "lm", se = F) +
  labs(
    x = "Month since first wave",
    y = "Average change since first wave (scaled 0-1)") +
  theme(legend.position="none") + 
  annotate("text", x = 40, y=0.2, label = "BES", 
           colour="#F8766D", fontface=2) +
  annotate("text", x = 150, y=0.175, label = "SHP", 
           colour="#00B6EB", fontface=2) +
  annotate("text", x = 100, y=0.12, label = "LISS", 
           colour="#53B400", fontface=2) +
  annotate("text", x = 57, y=0.10, label = "GLES", 
           colour="#C49A00", fontface=2) +
  annotate("text", x = 40, y=0.06, label = "USVSG", 
           colour="#9590FF", fontface=2) +
  annotate("text", x = 300, y=0.42, label = "USYP", 
           colour="#FF62BC", fontface=2) 

ggsave("meanchange1.png", 
       path = here("figures"))

# Figure 2: Greyscale version
# ggplot(graph_df, aes(month, mean, colour= panel, shape = panel)) + 
#   geom_point() +
#   theme_minimal() +
#   geom_smooth(method = "lm", se = F) +
#   labs(
#     x = "Month since first wave",
#     y = "Average change since first wave (scaled 0-1)") +
#   scale_color_grey()


# ----- Figure 3: Percentage changing categories between first and second and first and last wave -----
# for each panel

# First need to reshape to wide. This can take time to run.

bes_wide <- bes %>% 
  select(id, wave, trustMPs) %>%
  panel_data(., id = id, wave = wave) %>%
  widen_panel(., separator = "_")

liss_wide <- liss %>% select(id, time, confpolt) %>% 
  panel_data(., id = id, wave = time) %>%
  widen_panel(., separator = "_")

shp_wide <- shp %>% select(id, wave, pp04) %>% 
  panel_data(., id = id, wave = wave) %>%
  widen_panel(., separator = "_")

gles_wide <- gles %>% select(id, wave, trust_parl) %>%
  panel_data(., id = id, wave = wave) %>%
  widen_panel(., separator = "_")

usvsg_fig3 <- usvsg %>% select(id, trustgovt_2016, trustgovt_2017, trustgovt_2018, 
                          trustgovt_2019) 

usyp_fig3 <- usyp %>% select(id, trust65, trust82, trust97)

# generate the mean differences, proportion tables, merge then graph

bes_wide <- bes_wide %>%
  mutate(trw2 =abs(trustMPs_2 - trustMPs_1),
         trw20 = abs(trustMPs_20 - trustMPs_1))

besch1 <- as.data.frame(prop.table(table(bes_wide$trw2)))
besch1$wave <- "First to Second"
colnames(besch1) <- c("move", "percent", "wave")

besch2 <- as.data.frame(prop.table(table(bes_wide$trw20)))
besch2$wave <- "First to Last"
colnames(besch2) <- c("move", "percent", "wave")

besch <- rbind(besch1, besch2)
besch$move <- as.character(besch$move)

positions <- c("First to Second", "First to Last")

beschplot <- ggplot(besch, aes(x = move, y = percent, fill = wave)) +
  geom_bar(stat = "identity", position = position_dodge()) +
  labs(title = "",
       subtitle = '',
       x = "",
       y = "",
       fill = "") +
  theme_minimal() +
  theme(legend.position = "none")

liss_wide <- liss_wide %>%
  mutate(trw2 = abs(confpolt_2 - confpolt_1),
         trw12 = abs(confpolt_12 - confpolt_1)
  )

lissch1 <- as.data.frame(prop.table(table(liss_wide$trw2)))
lissch1$wave <- "First to Second"
colnames(lissch1) <- c("move", "percent", "wave")

lissch2 <- as.data.frame(prop.table(table(liss_wide$trw12)))
lissch2$wave <- "First to Last"
colnames(lissch2) <- c("move", "percent", "wave")

lissch <- rbind(lissch1, lissch2)

lisschplot <- ggplot(lissch, aes(x = move, y = percent, fill = wave)) +
  geom_bar(stat = "identity", position = position_dodge()) +
  labs(title = "",
       subtitle = '',
       x = "",
       y = "") +
  theme_minimal() +
  theme(legend.position = "none")

shp_wide <- shp_wide %>%
  mutate(trw2 = abs(pp04_2 - pp04_1),
         trw20 = abs(pp04_19 - pp04_1),
  )

shpch1 <- as.data.frame(prop.table(table(shp_wide$trw2)))
shpch1$wave <- "First to Second"
colnames(shpch1) <- c("move", "percent", "wave")

shpch2 <- as.data.frame(prop.table(table(shp_wide$trw20)))
shpch2$wave <- "First to Last"
colnames(shpch2) <- c("move", "percent", "wave")

shpch <- rbind(shpch1, shpch2)

shpchplot <- ggplot(shpch, aes(x = move, y = percent, fill = wave)) +
  geom_bar(stat = "identity", position = position_dodge()) +
  labs(title = "",
       subtitle = '',
       x = "",
       y = "") +
  theme_minimal() +
  theme(legend.position = "none")

gles_wide <- gles_wide %>%
  mutate(
    trw9 = abs(trust_parl_9 - trust_parl_2),
    trw13 = abs(trust_parl_13 - trust_parl_2)
  )


glesch1 <- as.data.frame(prop.table(table(gles_wide$trw9)))
glesch1$wave <- "First to Second"
colnames(glesch1) <- c("move", "percent", "wave")

glesch2 <- as.data.frame(prop.table(table(gles_wide$trw13)))
glesch2$wave <- "First to Last"
colnames(glesch2) <- c("move", "percent", "wave")

glesch <- rbind(glesch1, glesch2)

gleschplot <- ggplot(glesch, aes(x = move, y = percent, fill = wave)) +
  geom_bar(stat = "identity", position = position_dodge()) +
  labs(title = "",
       subtitle = '',
       x = "",
       y = "") +
  theme_minimal() +
  theme(legend.position = "none")


usvsg_fig3 <- usvsg_fig3 %>%
  mutate(trw2 = abs(trustgovt_2017 - trustgovt_2016),
         trw4 = abs(trustgovt_2019 - trustgovt_2016))


usvsgch1 <- as.data.frame(prop.table(table(usvsg_fig3$trw2)))
usvsgch1$wave <- "First to Second"
colnames(usvsgch1) <- c("move", "percent", "wave")

usvsgch2 <- as.data.frame(prop.table(table(usvsg_fig3$trw4)))
usvsgch2$wave <- "First to Last"
colnames(usvsgch2) <- c("move", "percent", "wave")

usvsgch <- rbind(usvsgch1, usvsgch2)

usvsgchplot <-ggplot(usvsgch, aes(x = move, y = percent, fill = wave)) +
  geom_bar(stat = "identity", position = position_dodge()) +
  labs(title = "",
       subtitle = '',
       x = "",
       y = "") +
  theme_minimal() +
  theme(legend.position = "none")

usyp_fig3 <- usyp_fig3 %>% 
  mutate(trw2 = abs(trust82 - trust65),
         trw3 = abs(trust97 - trust65))

usypch1 <- as.data.frame(prop.table(table(usyp_fig3$trw2)))
usypch1$wave <- "First to Second"
colnames(usypch1) <- c("move", "percent", "wave")

usypch2 <- as.data.frame(prop.table(table(usyp_fig3$trw3)))
usypch2$wave <- "First to Last"
colnames(usypch2) <- c("move", "percent", "wave")

usypch <- rbind(usypch1, usypch2)

usypchplot <- ggplot(usypch, aes(x = move, y = percent, fill = wave)) +
  geom_bar(stat = "identity", position = position_dodge()) +
  labs(title = "",
       subtitle = '',
       x = "",
       y = "",
       fill = "") +
  theme_minimal() 


change_plot <- ggarrange(beschplot, lisschplot, shpchplot, gleschplot, usvsgchplot, usypchplot,
                         common.legend=T,
                         legend = "bottom",
                         labels = c("BES", "LISS", "SHP", "GLES", "USVSG", "USYP"))


annotate_figure(change_plot,
                bottom = text_grob("Note: Number of waves/years varies between panels")
)

ggsave("meanchange2.png", 
       path = here("figures"))

# Greyscale version
# beschplot <- ggplot(besch, aes(x = move, y = percent, fill = wave)) +
#   geom_bar(stat = "identity", position = position_dodge()) +
#   labs(title = "",
#        subtitle = '',
#        x = "",
#        y = "",
#        fill = "") +
#   theme_minimal() +
#   theme(legend.position = "none")+ scale_colour_grey(aesthetics = "fill")
# 
# lisschplot <- ggplot(lissch, aes(x = move, y = percent, fill = wave)) +
#   geom_bar(stat = "identity", position = position_dodge()) +
#   labs(title = "",
#        subtitle = '',
#        x = "",
#        y = "") +
#   theme_minimal() +
#   theme(legend.position = "none")+ scale_colour_grey(aesthetics = "fill")
# 
# shpchplot <- ggplot(shpch, aes(x = move, y = percent, fill = wave)) +
#   geom_bar(stat = "identity", position = position_dodge()) +
#   labs(title = "",
#        subtitle = '',
#        x = "",
#        y = "") +
#   theme_minimal() +
#   theme(legend.position = "none")+ scale_colour_grey(aesthetics = "fill")
# 
# gleschplot <- ggplot(glesch, aes(x = move, y = percent, fill = wave)) +
#   geom_bar(stat = "identity", position = position_dodge()) +
#   labs(title = "",
#        subtitle = '',
#        x = "",
#        y = "") +
#   theme_minimal() +
#   theme(legend.position = "none")+ scale_colour_grey(aesthetics = "fill")
# 
# usvsgchplot <-ggplot(usvsgch, aes(x = move, y = percent, fill = wave)) +
#   geom_bar(stat = "identity", position = position_dodge()) +
#   labs(title = "",
#        subtitle = '',
#        x = "",
#        y = "") +
#   theme_minimal() +
#   theme(legend.position = "none")+ scale_colour_grey(aesthetics = "fill")
# 
# usypchplot <- ggplot(usypch, aes(x = move, y = percent, fill = wave)) +
#   geom_bar(stat = "identity", position = position_dodge()) +
#   labs(title = "",
#        subtitle = '',
#        x = "",
#        y = "",
#        fill = "") +
#   theme_minimal() + scale_colour_grey(aesthetics = "fill")
# change_plot <- ggarrange(beschplot, lisschplot, shpchplot, gleschplot, usvsgchplot, usypchplot,
#                          common.legend=T,
#                          legend = "bottom",
#                          labels = c("BES", "LISS", "SHP", "GLES", "USVSG", "USYP")) + scale_color_grey()
# 
# 
# annotate_figure(change_plot,
#                 bottom = text_grob("Note: Number of waves/years varies between panels")
# )

