**********************
*REPLICATION MATERIAL FOR:
*Garritzmann, Julian L., Erik Neimanns, and Marius R. Busemeyer: Public Opinion towards Welfare State Reform: The Role of Political Trust and Government Satisfaction 
*published in: European Journal of Political Research
*Analysis of ESS 2016 data ("Study 2" in the paper)
**********************

clear
set more off
*load ESS 2016 data: http://www.europeansocialsurvey.org/
use "/[...]/ESS8e02_1.dta"

svyset [pweight=dweight]

************************************************
*variable coding
************************************************

*drop Russia from sample:
drop if cntry=="RU"

egen cntry_no=group(cntry)

*define Inveduc sample: Denmark is missing in ESS 2016
gen inveduc=0
replace inveduc=1 if cntry=="DE" |cntry=="ES" |cntry=="FR" |cntry=="GB" |cntry=="IE" |cntry=="IT" |cntry=="SE"

************************************************
*gvtpartyvoter: voted for government parties 
*fieldwork period from ESS: http://nesstar.ess.nsd.uib.no/webview/
*cabinet composition from parlgov.org for 
************************************************
gen gvtpartyvoter=0
replace gvtpartyvoter=1 if (prtvtbat==1|prtvtbat==2) & cntry=="AT" /* */ 
replace gvtpartyvoter=1 if (prtvtcbe==2|prtvtcbe==3 |prtvtcbe==8 |prtvtcbe==12) & cntry=="BE" /* */ 
replace gvtpartyvoter=1 if (prtvtfch==1|prtvtfch==2 |prtvtfch==3 |prtvtfch==4) & cntry=="CH" /* */ 
replace gvtpartyvoter=1 if (prtvtdcz==2|prtvtdcz==4 |prtvtdcz==6) & cntry=="CZ" /* */ 
replace gvtpartyvoter=1 if (prtvede1==1|prtvede1==2|prtvede2==1|prtvede2==2) & cntry=="DE" /* */ 
replace gvtpartyvoter=1 if (prtvtfee==2|prtvtfee==4|prtvtfee==3) & cntry=="EE" /* */ 
replace gvtpartyvoter=1 if (prtvtdes==1) & cntry=="ES" /* */ 
replace gvtpartyvoter=1 if (prtvtdfi==1|prtvtdfi==3|prtvtdfi==4) & cntry=="FI" /* */ 
replace gvtpartyvoter=1 if (prtvtcfr==1|prtvtcfr==2) & cntry=="FR" /* */ 
replace gvtpartyvoter=1 if (prtvtbgb==1) & cntry=="GB" /* */ 
replace gvtpartyvoter=1 if (prtvtehu==1) & cntry=="HU" /* */ 
replace gvtpartyvoter=1 if (prtvtbie==3|prtvtbie==5) & cntry=="IE" /* */ 
replace gvtpartyvoter=1 if (prtvtcil==2|prtvtcil==9|prtvtcil==6|prtvtcil==4|prtvtcil==3|prtvtcil==7) & cntry=="IL" /* */ 
replace gvtpartyvoter=1 if (prtvtbis==3|prtvtbis==12|prtvtbis==1) & cntry=="IS" /* */ 
replace gvtpartyvoter=1 if (prtvtbit==1|prtvtbit==6) & cntry=="IT" /* */ 
replace gvtpartyvoter=1 if (prtvblt1==6) & cntry=="LT" /* */ 
replace gvtpartyvoter=1 if (prtvtfnl==1|prtvtfnl==2) & cntry=="NL" /* */ 
replace gvtpartyvoter=1 if (prtvtbno==7|prtvtbno==8) & cntry=="NO" /* */ 
replace gvtpartyvoter=1 if (prtvtdpl==6) & cntry=="PL" /* */ 
replace gvtpartyvoter=1 if (prtvtcpt==13) & cntry=="PT" /* */ 
replace gvtpartyvoter=1 if (prtvtbse==4|prtvtbse==6) & cntry=="SE" /* */ 
replace gvtpartyvoter=1 if (prtvtesi==1|prtvtesi==5|prtvtesi==8) & cntry=="SI" /* */ 

*dv: trade-offs: eduunmp, wrkprbf
gen to_ue=eduunmp
recode to_ue (3 4=1) (1 2=0)
gen to_ue_ordered=eduunmp

gen to_tax=wrkprbf
recode to_tax (3 4=1) (1 2=0)
gen to_tax_ordered=wrkprbf

*educ: 
gen educlevel=eisced
recode educlevel (55=.)

*hh income: hinctnta
gen hhincome=hinctnta

gen hhincome_q5=hhincome
recode hhincome_q5 (1 2=1)(3 4=2)(5 6=3)(7 8=4)(9 10=5)
tab hhincome_q5, gen(hhincome_q5_)

*female: gndr
gen female=gndr
recode female (1=0) (2=1)

*kids: chldhm
gen kids=chldhm
recode kids (2=0)

*currentsit: mnactic
gen currentsit=mnactic
recode currentsit (4=3)(5 7 8=9)

tab currentsit, gen(currentsit_)
tab mnactic, gen(mnactic_)

*age: agea
gen age=agea
 
*nradults: icpart3
gen nradults=icpart3
recode nradults (2=0)

*unemplrisk: lkuemp
gen unemplrisk=lkuemp
recode unemplrisk (55=0)

*lire: lrscale
gen lire=lrscale

*categorical left-righ(-center) placement: 0:left, 1: center, 2: right 
gen lire_cat=lire
recode lire_cat (0 1 2 3 = 0) (4 5 6 = 1) (7 8 9 10=2)

*trust: trstprl trstlgl trstplt trstprt  

*gvtsatis: stfgov
gen gvtsatis=stfgov







*********************
*analysis (replication file)
*********************

*Table 2: Average marginal effects of political trust on support for welfare state reforms, ESS data.
*Table A.10: Regression table – effect of different measures of government satisfaction and political trust on reform scenarios (Study 2)
melogit to_ue gvtsatis educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no: 
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side replace
margins, dydx(gvtsatis) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side replace
melogit to_ue trstprl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/ ||cntry_no: 
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side 
margins, dydx(trstprl) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side 
melogit to_ue trstlgl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no: 
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side 
margins, dydx(trstlgl) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side 
melogit to_ue trstplt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no: 
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side 
margins, dydx(trstplt) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side 
melogit to_ue trstprt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no: 
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side 
margins, dydx(trstprt) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax gvtsatis educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no:
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side 
margins, dydx(gvtsatis) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax trstprl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no:
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side 
margins, dydx(trstprl) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax trstlgl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no: 
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side 
margins, dydx(trstlgl) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax trstplt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no: 
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side 
margins, dydx(trstplt) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax trstprt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  ||cntry_no: 
 outreg2 using reg280317breg, dec(2) stats(coef se pval) noaster noparen side excel
margins, dydx(trstprt) post
 outreg2 using reg280317b, dec(2) stats(coef se pval) noaster noparen side excel

*Table A.9: List of question wording and descriptive statistics for all variables for Study 2 (ESS)
sum gvtsatis trstprl trstlgl trstplt trstprt educlevel hhincome_q5 female kids currentsit_1 currentsit_2 currentsit_3  currentsit_4 currentsit_5 age nradults unemplrisk

*Table A.12: Regression table – robustness test: including country fixed effects (Study 2)
logit to_ue gvtsatis educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no 
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side replace
margins, dydx(gvtsatis) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side replace
logit to_ue trstprl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/ i.cntry_no 
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side 
margins, dydx(trstprl) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side 
logit to_ue trstlgl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no 
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side 
margins, dydx(trstlgl) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side 
logit to_ue trstplt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no 
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side 
margins, dydx(trstplt) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side 
logit to_ue trstprt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no 
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side 
margins, dydx(trstprt) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side 
logit to_tax gvtsatis educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side 
margins, dydx(gvtsatis) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side 
logit to_tax trstprl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side 
margins, dydx(trstprl) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side 
logit to_tax trstlgl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no 
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side 
margins, dydx(trstlgl) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side 
logit to_tax trstplt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no 
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side 
margins, dydx(trstplt) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side 
logit to_tax trstprt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk /*ib1.lire_cat*/  i.cntry_no 
 outreg2 using reg220120, dec(3) stats(coef se pval) noaster noparen side excel
margins, dydx(trstprt) post
 outreg2 using reg220120b, dec(3) stats(coef se pval) noaster noparen side excel

*Table A.17: Regression table - robustness test: including attitudinal control variables (Study 2)
melogit to_ue gvtsatis educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter ||cntry_no: 
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side replace
melogit to_ue trstprl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter ||cntry_no: 
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side 
melogit to_ue trstlgl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter  ||cntry_no: 
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side 
melogit to_ue trstplt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter  ||cntry_no: 
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side 
melogit to_ue trstprt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter ||cntry_no: 
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax gvtsatis educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter  ||cntry_no:
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax trstprl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter  ||cntry_no:
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax trstlgl educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter  ||cntry_no: 
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax trstplt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter  ||cntry_no: 
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side 
melogit to_tax trstprt educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk ib1.lire_cat gvtpartyvoter  ||cntry_no: 
 outreg2 using reg140421ess_wattC, dec(2) stats(coef se pval) noaster noparen side excel

*Table A.19: Regression table – interaction effects for ideological costs (Study 2)
*Table A.20: Marginal effects of political trust and government satisfaction for ideological loser groups (Study 2)
eststo clear 
melogit to_ue c.gvtsatis##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter ||cntry_no: 
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side replace
eststo: margins i(0).lire_cat, dydx(gvtsatis) post
melogit to_ue c.trstprl##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter ||cntry_no: 
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side 
eststo: margins i(0).lire_cat, dydx(trstprl) post
melogit to_ue c.trstlgl##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter  ||cntry_no: 
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side 
eststo: margins i(0).lire_cat, dydx(trstlgl) post
melogit to_ue c.trstplt##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter  ||cntry_no: 
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side 
eststo: margins i(0).lire_cat, dydx(trstplt) post
melogit to_ue c.trstprt##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter ||cntry_no: 
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side 
eststo: margins i(0).lire_cat, dydx(trstprt) post
melogit to_tax c.gvtsatis##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter  ||cntry_no:
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side 
eststo: margins i(2).lire_cat, dydx(gvtsatis) post
melogit to_tax c.trstprl##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter  ||cntry_no:
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side 
eststo: margins i(2).lire_cat, dydx(trstprl) post
melogit to_tax c.trstlgl##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter  ||cntry_no: 
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side 
eststo: margins i(2).lire_cat, dydx(trstlgl) post
melogit to_tax c.trstplt##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter  ||cntry_no: 
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side 
eststo: margins i(2).lire_cat, dydx(trstplt) post
melogit to_tax c.trstprt##ib1.lire_cat educlevel ib3.hhincome_q5 female kids i.currentsit age nradults unemplrisk gvtpartyvoter  ||cntry_no: 
 *outreg2 using ESSreg230621_iacts, dec(2) stats(coef se pval) noaster noparen side excel
eststo: margins i(2).lire_cat, dydx(trstprt) post

esttab using table_margins.htm, scalars(r2 F) se  nogaps nobaselevels unstack noomitted label replace ///
starlevels(* 0.05 ** 0.01 *** 0.001) ///
title("Marginal effects of trust (M1-5: unemployment trade-off; M6-10: fiscal trade-off; lire_cat: 0=left; 2=right)") ///
alignment(D{.}{.}{-1})

*Table A.21: Correlations between government satisfaction and political trust by country (Study 2)
pwcorr  trstprl trstlgl trstplt trstprt gvtsatis if inveduc==1, sig obs 
pwcorr  trstprl trstlgl trstplt trstprt gvtsatis if cntry=="DE", sig obs 
pwcorr  trstprl trstlgl trstplt trstprt gvtsatis if cntry=="FR", sig obs 
pwcorr  trstprl trstlgl trstplt trstprt gvtsatis if cntry=="IT", sig obs 
pwcorr  trstprl trstlgl trstplt trstprt gvtsatis if cntry=="ES", sig obs 
pwcorr  trstprl trstlgl trstplt trstprt gvtsatis if cntry=="SE", sig obs 
pwcorr  trstprl trstlgl trstplt trstprt gvtsatis if cntry=="IE", sig obs 
pwcorr  trstprl trstlgl trstplt trstprt gvtsatis if cntry=="GB", sig obs 


* Note on Figure 3:
* as described in the text, Figure 3 plots the average government satisfaction values in each country (using the "gvtsatis" variable), against countries' social investment
/// effort as measured by Stefano Ronchi. The data by Ronchi can be downloaded on his homepage: https://sronchi.wordpress.com/siwe-data-set/ We simply scatter-plotted one 
/// against the other, collapsing the ESS data by country (not done in this do-file here, as the data format changes away from the micro-level to the country-level).
