**********************
*REPLICATION MATERIAL FOR:
*Garritzmann, Julian L., Erik Neimanns, and Marius R. Busemeyer: Public Opinion towards Welfare State Reform: The Role of Political Trust and Government Satisfaction 
*published in: European Journal of Political Research
*Analysis of Inveduc 2014 data ("Study 1" in the paper)
**********************

************************************************
*load data:
*Busemeyer, Marius R., Garritzmann, Julian, Neimanns, Erik, & Nezi, Roula (2018). Investing in Education in Europe: Attitudes, Politics and Policies (INVEDUC). GESIS Datenarchiv, Köln. ZA6961 Datenfile Version 1.0.0, https://doi.org/10.4232/1.13140.
************************************************
clear
set more off
use "/[...]/ZA6961_v1-0-0.dta"
svyset [pweight=GEW_ALL]

************************************************
*variable coding
************************************************

*gen common education level variable
gen educlevel=.
replace educlevel=Q641 if COUNTRYCODE==13 /*Germany*/
replace educlevel=Q642 if COUNTRYCODE==31 /*Denmark*/
replace educlevel=Q643 if COUNTRYCODE==25 /*UK*/
replace educlevel=Q644 if COUNTRYCODE==15 /*Italy*/
replace educlevel=Q645 if COUNTRYCODE==18 /*Sweden*/
replace educlevel=Q646 if COUNTRYCODE==35 /*Ireland*/
replace educlevel=Q647 if COUNTRYCODE==16 /*Spain*/
replace educlevel=Q648 if COUNTRYCODE==51 /*France*/
replace educlevel=. if educlevel>6

*merge educational degrees: educlevel_trans: 3 categories only
gen educlevel_trans=educlevel
recode educlevel_trans (2=1) (3=2) (4=2) (5=3)

*household income (quintiles)
recode Q74 8=. 9=.
rename Q74 hhincome
*dummy coding 
gen hhincome1=hhincome
recode hhincome1 (1=1)(2 3 4 5=0)
gen hhincome2=hhincome
recode hhincome2 (2=1)(1 3 4 5=0)
gen hhincome3=hhincome
recode hhincome3 (3=1)(1 2 4 5=0)
gen hhincome4=hhincome
recode hhincome4 (4=1)(1 2 3 5=0)
gen hhincome5=hhincome
recode hhincome5 (5=1)(1 2 3 4=0)

*age
recode Q11 9999=.
gen age=2014-Q11

*gender
gen female=.
replace female=1 if Q12==2
replace female=0 if Q12==1

*how many children
recode Q78 9=.
gen nrkids=Q78
replace nrkids=0 if Q77==1

*kids dummy
gen kids_dum=nrkids
replace kids_dum=1 if nrkids>1 & nrkids<.

*how many young children
recode Q79 9=.
gen nrsmallkids=Q79
replace nrsmallkids=0 if Q78==0
replace nrsmallkids=0 if Q77==1

*small kids dummy
gen smallkids_dummy=.
replace smallkids_dummy=1 if nrsmallkids>=1
replace smallkids_dummy=0 if nrsmallkids==0
replace smallkids_dummy=. if nrsmallkids==.

*old kids dummy 
*number of old kids: (nrkids-nrsmallkids)
gen nroldkids=nrkids-nrsmallkids
replace nroldkids=. if nroldkids<0
gen oldkids_dummy=nroldkids
replace oldkids_dummy=1 if nroldkids>=1 & nroldkids<.


*how many adults in HH (Q77-nrkids)
recode Q77 (99=.)
gen nradults=Q77-nrkids
replace nradults=1 if nradults<1
*histogram nradults, by (COUNTRYCODE)
gen nradults_dum=nradults
replace nradults_dum=2 if nradults>2 & nradults<.

*left-right placement
gen lire=Q55
recode lire (99=.)
label values lire Q55

*categorical left-righ(-center) placement: 0:left, 1: center, 2: right 
gen lire_cat=lire
recode lire_cat (0 1 2 3 = 0) (4 5 6 = 1) (7 8 9 10=2) 
*dummy coding:
gen lire_left=lire_cat
recode lire_left (0=1) (1 2=0)
gen lire_right=lire_cat
recode lire_right (2=1) (1 0=0)

*respondent´s current situation
gen currentsit=Q6602
recode currentsit (.=6) (98=.) (99=.)
replace currentsit=7 if Q6602==6 & Q6601>=2 & Q6601<=3
replace currentsit=8 if Q67>=2 & Q67<=4
label values currentsit Q6602
label define Q6602 6 "working full time" 7 "work. part-time, volunt." 8 "work. part-time, involunt.", modify

*currentsitv3: merge categories
gen currentsitv3=currentsit
recode currentsitv3 (4=96)(5=96)(7=96)(8=96)
label values currentsitv3 Q6602
*current situation: separate dummies
gen currentsitv3_1_ue=currentsitv3
gen currentsitv3_2_stud=currentsitv3
gen currentsitv3_3_ret=currentsitv3
gen currentsitv3_6_work=currentsitv3
gen currentsitv3_9_oth=currentsitv3
recode currentsitv3_1_ue (1=1)(2=0)(3=0)(6=0)(96=0) 
recode currentsitv3_2_stud (1=0)(2=1)(3=0)(6=0)(96=0)  
recode currentsitv3_3_ret (1=0)(2=0)(3=1)(6=0)(96=0)  
recode currentsitv3_6_work (1=0)(2=0)(3=0)(6=1)(96=0)  
recode currentsitv3_9_oth (1=0)(2=0)(3=0)(6=0)(96=1)  
label var currentsitv3_1_ue "unempl."
label var currentsitv3_2_stud "student"
label var currentsitv3_3_ret "retired"
label var currentsitv3_6_work "working"
label var currentsitv3_9_oth "other"

*unemployment risk
gen unemplrisk=Q73
recode unemplrisk (.=97) (8=.) (9=.)
label values unemplrisk Q73
label define Q73 97 "not applicable", modify

*unemployment risk (dummy)
gen unemplrisk_dummy=unemplrisk
recode unemplrisk_dummy (97=0) (2=1) (3=0) (4=0)
label values unemplrisk_dummy yesno


*country (string variable)
gen country="DE" if COUNTRYCODE==13
replace country="DK" if COUNTRYCODE==31
replace country="ES" if COUNTRYCODE==16
replace country="FR" if COUNTRYCODE==51
replace country="IE" if COUNTRYCODE==35
replace country="IT" if COUNTRYCODE==15
replace country="SE" if COUNTRYCODE==18
replace country="UK" if COUNTRYCODE==25

*country number
gen countryno=1 if COUNTRYCODE==13
replace countryno=2 if COUNTRYCODE==15
replace countryno=3 if COUNTRYCODE==16
replace countryno=4 if COUNTRYCODE==18
replace countryno=5 if COUNTRYCODE==25
replace countryno=6 if COUNTRYCODE==31
replace countryno=7 if COUNTRYCODE==35
replace countryno=8 if COUNTRYCODE==51
label define countryno 1"DE" 2"IT" 3"ES" 4"SE" 5"UK" 6"DK" 7"IE" 8"FR"
label values countryno countryno

*general spending preference
gen genspend=Q19
recode genspend 8=. 9=.
label values genspend Q19
recode genspend (1=5) (2=4) (4=2) (5=1)
label define spendmoreless_reversed 1"Spend much less" 2"Spend less" 3"Spend the same as now" 4"Spend more " 5"Spend much more ", modify
label values genspend spendmoreless_reversed

* binary transformation of Q34-Q37 (gov should increase education spending, even if...)
gen Q34bin=.
replace Q34bin=1 if Q34==1 | Q34==2
replace Q34bin=0 if Q34==3 | Q34==4 | Q34==5

gen Q35bin=.
replace Q35bin=1 if Q35==1 | Q35==2
replace Q35bin=0 if Q35==3 | Q35==4 | Q35==5

gen Q36bin=.
replace Q36bin=1 if Q36==1 | Q36==2
replace Q36bin=0 if Q36==3 | Q36==4 | Q36==5

gen Q37bin=.
replace Q37bin=1 if Q37==1 | Q37==2
replace Q37bin=0 if Q37==3 | Q37==4 | Q37==5

*recode missings
recode Q34 (8=.) (9=.)
recode Q35 (8=.) (9=.)
recode Q36 (8=.) (9=.)
recode Q37 (8=.) (9=.)

*reverse scale
recode Q34 (1=5) (2=4) (4=2) (5=1)
recode Q35 (1=5) (2=4) (4=2) (5=1)
recode Q36 (1=5) (2=4) (4=2) (5=1)
recode Q37 (1=5) (2=4) (4=2) (5=1)
label define agreedisagree_reversed 1"strongly disagree" 2"disagree" 3"neither agree nor disagree" 4"agree" 5"strongly agree", modify
label values Q34-Q37 agreedisagree_reversed

* binary transformation of Q38-1/2
gen socinv=.
replace socinv=1 if Q3801==1 | Q3801==2
replace socinv=0 if Q3801==3 | Q3801==4 | Q3801==5

gen passwfs=.
replace passwfs=1 if Q3802==1 | Q3802==2
replace passwfs=0 if Q3802==3 | Q3802==4 | Q3802==5

recode Q3801 (1=5) (2=4) (4=2) (5=1) (8=.) (9=.)
recode Q3802 (1=5) (2=4) (4=2) (5=1) (8=.) (9=.)
label define agreedisagree_reversed 1"strongly disagree" 2"disagree" 3"neither agree nor disagree" 4"agree" 5"strongly agree", modify
label values Q3801 Q3802 agreedisagree_reversed




*political trust/gvt satisfaction:
gen poltrust=Q13
replace poltrust=. if Q13==8
replace poltrust=. if Q13==9
recode poltrust (1=5) (2=4) (4=2) (5=1)



****
*code trade-off variables
****
*Q51/Q52/Q53/54: tradeoffs
recode Q51 Q52 Q53 Q54 (8=.a) (9=.b)

foreach var of varlist Q51 Q52 Q53 Q54  {
 gen `var'dum=`var'
 recode `var'dum (1=1)(2=1)(3=0)(4=0)(5=0)
}
foreach var of varlist Q51 Q52 Q53 Q54  {
 gen `var'rec=`var'
 recode `var'rec (1=5)(2=4)(3=3)(4=2)(5=1)
}
*

*merge trade-off split (dummy coding):
gen to_merged=Q51dum
replace to_merged=Q52dum if to_merged==.
replace to_merged=Q53dum if to_merged==.
replace to_merged=Q54dum if to_merged==.

*indicate whether a specific trade-off was asked
gen to_educue=Q51dum
recode to_educue (0=1) (.=0)
gen to_educpens=Q52dum
recode to_educpens (0=1) (.=0)
gen to_famue=Q53dum
recode to_famue (0=1) (.=0)
gen to_fampens=Q54dum
recode to_fampens (0=1) (.=0)

****same for Q34-37:
*merge trade-off split (dummy coding):
gen to_merged34ff=Q34bin
replace to_merged34ff=Q35bin if to_merged34ff==.
replace to_merged34ff=Q36bin if to_merged34ff==.
replace to_merged34ff=Q37bin if to_merged34ff==.
*indicate whether a specific trade-off was asked
gen to_34ff_c=Q34bin
recode to_34ff_c (0=1) (.=0)
gen to_34ff_t1=Q35bin
recode to_34ff_t1 (0=1) (.=0)
gen to_34ff_t2=Q36bin
recode to_34ff_t2 (0=1) (.=0)
gen to_34ff_t3=Q37bin
recode to_34ff_t3 (0=1) (.=0)
****

****same for socinv & passwfs:
*merge trade-off split (dummy coding):
gen to_merged3801ff=socinv
replace to_merged3801ff=passwfs if to_merged3801ff==.
*indicate whether a specific trade-off was asked
gen to_3801ff_inv=socinv
recode to_3801ff_inv (0=1) (.=0)
gen to_3801ff_pass=passwfs
recode to_3801ff_pass (0=1) (.=0)
****


***********************************************************************************************************************************************
*recode missing/other party affiliations based on responses to open question:
sort ID
gen runningno=_n

*DE
*list runningno TQ56 Q56 if Q56==96
replace Q56=6 if runningno==959
replace Q56=9 if runningno==971
replace Q56=6 if runningno==1077
replace Q56=7 if runningno==1412
replace Q56=5 if runningno==1475

*DK
*list runningno TQ57 Q57 if Q57==96
replace Q57=9 if runningno==5904

*UK
*list runningno TQ58 Q58 if Q58==96
replace Q58=11 if runningno==4884
replace Q58=11 if runningno==4931
replace Q58=1 if runningno==5197
replace Q58=11 if runningno==5368

*IT
*list runningno TQ59 Q59 if Q59==96
replace Q59=7 if runningno==1539 // Forza Italia emerged in 2013 after Popolo della Libert‡ split up
replace Q59=7 if runningno==1752 // Popolo della Libert‡ --> Forza Italia
replace Q59=7 if runningno==2095 // Popolo della Libert‡ --> Forza Italia
replace Q59=7 if runningno==2248 // Popolo della Libert‡ --> Forza Italia
replace Q59=7 if runningno==2411 // Popolo della Libert‡ --> Forza Italia
replace Q59=7 if runningno==2440 // Popolo della Libert‡ --> Forza Italia
replace Q59=7 if runningno==1684 // Nuovo Centrodestra emerged in 2013 after Popolo della Libert‡ split up
replace Q59=7 if runningno==1864 // Popolo della Libert‡ --> Nuovo Centrodestra
replace Q59=7 if runningno==2054 // Popolo della Libert‡ --> Nuovo Centrodestra
replace Q59=7 if runningno==2422 // Popolo della Libert‡ --> Nuovo Centrodestra
replace Q59=7 if runningno==1676 // Fratelli d'Italia (Alleanza Nazionale) broke away from Popolo della Libert‡ in 2012
replace Q59=7 if runningno==1691 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==1701 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==1755 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==1780 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==1836 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==1945 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==1971 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==2022 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==2320 // Popolo della Libert‡ --> Fratelli d'Italia (Alleanza Nazionale)
replace Q59=7 if runningno==2267 
replace Q59=8 if runningno==2142

*SE
*list runningno TQ60 Q60 if Q60==96
replace Q60=5 if runningno==4064
*add Feministiskt initiativ (N=40)
replace Q60=9 if runningno==3517 | runningno==3626 | runningno==3632 | runningno==3632 | runningno==3674 | runningno==3793 | runningno==3797 | runningno==3843 | runningno==3867 | runningno==3908 | runningno==3947 | runningno==3956 | runningno==3972 | runningno==3978 | runningno==4020 |runningno==4021 | runningno==4054 | runningno==4056 |runningno==4062 | runningno==4095 | runningno==4096 | runningno==4107 | runningno==4130 | runningno==4171 | runningno==4213 | runningno==4251 | runningno==4260 | runningno==4271 | runningno==4293 | runningno==4342 | runningno==4366 | runningno==4384 | runningno==4390 | runningno==4452 | runningno==4464 | runningno==4498 | runningno==4514 | runningno==4523 | runningno==4526 | runningno==4535 | runningno==4599
label define Q60 9 "Feministiskt initiativ", modify

*IE
*list runningno TQ61 Q61 if Q61==96
*no change

*ES
*code Ciudadanos and Podemos as additional parties
*list runningno TQ62 Q62 if Q62==96
replace Q62=3 if runningno==2752
replace Q62=4 if runningno==3339
replace Q62=4 if runningno==2654
replace Q62=7 if runningno==2549
replace Q62=7 if runningno==3480
*add Podemos (N=7)
replace Q62=10 if runningno==2520 |runningno==2965 |runningno==3029 |runningno==3236 |runningno==3322 |runningno==3326 |runningno==3399 
*add Ciudadanos (N=13)
replace Q62=11 if runningno==2521 |runningno==2572 |runningno==2634 |runningno==2722 |runningno==2741 |runningno==2933 |runningno==3204 |runningno==3216 |runningno==3253 |runningno==3347 |runningno==3446 |runningno==3460 |runningno==3481 
label define Q62 10 "Podemos" 11 "Ciudadanos", modify

*FR
*list runningno TQ63 Q63 if Q63==96
replace Q63=13 if runningno==8215
***********************************************************************************************************************************************


*dummy for government party voter:
gen gvtpartyvoter=0
replace gvtpartyvoter=1 if Q56==1|Q56==2|Q56==3  
replace gvtpartyvoter=1 if Q57==1|Q57==2  
replace gvtpartyvoter=1 if Q58==1|Q58==3  
replace gvtpartyvoter=1 if Q59==1  
replace gvtpartyvoter=1 if Q60==8|Q60==3|Q60==4|Q60==6 
replace gvtpartyvoter=1 if Q61==1|Q61==2  
replace gvtpartyvoter=1 if Q62==1  
replace gvtpartyvoter=1 if Q63==1|Q63==4 

*vote choice in the eight countries:
recode Q56 Q57 Q58 Q59 Q60 Q61 Q62 Q63 (.=0)(91 92 93 94 95 96=99)

*label variables:
label var poltrust "Political trust"
label var hhincome "Income"
label var currentsitv3_1_ue "Unemployed"
label var currentsitv3_3_ret "Retired"

*age groups:
gen age20s=0  
replace age20s=1 if age <30
gen age30s=0
replace age30s=1 if  age >=30 & age <40
gen age40s=0
replace age40s=1 if  age >=40 & age <50
gen age50s=0
replace age50s=1 if  age >=50 & age <60
gen age60s=0
replace age60s=1 if  age >=60 & age <.
*age groups:
gen age20sall=0  
replace age20sall=1 if  age <30
gen age30sall=0
replace age30sall=1 if  age >=30 & age <40
gen age40sall=0
replace age40sall=1 if  age >=40 & age <50
gen age50sall=0
replace age50sall=1 if  age >=50 & age <60
gen age60sall=0
replace age60sall=1 if  age >=60 & age <.


**************************************************************************
*duplicate data to combine three trade-off scenarios
**************************************************************************
*************************************
*additional variable coding for duplicated dataset:
**************************************
expand 3
by ID, sort: gen dupl_no=_n

*generate overall trade-off variable:
sum to_merged34ff to_34ff_c to_34ff_t1 to_34ff_t2 to_34ff_t3 to_merged to_educue to_educpens to_famue to_fampens  socinv
*TO1: to_merged34ff
	*dummy indicating respective TO split: to_34ff_c to_34ff_t1 to_34ff_t2 to_34ff_t3
*TO2: to_merged
	*dummy indicating respective TO split: to_educue to_educpens to_famue to_fampens
*TO3: to_merged3801ff  
	*dummy indicating respective TO split: to_3801ff_inv to_3801ff_pass
*all dummies taken together: to_34ff_c to_34ff_t1 to_34ff_t2 to_34ff_t3 to_educue to_educpens to_famue to_fampens to_3801ff_inv to_3801ff_pass
gen to_merged123=to_merged34ff if dupl_no==1
replace to_merged123=to_merged if dupl_no==2
replace to_merged123=to_merged3801ff if dupl_no==3

*dummy coding indicating TO under question in pooled data:
gen TOX_X=0
replace TOX_X=1 if to_34ff_c==1 & dupl_no==1
replace TOX_X=2 if to_34ff_t1==1 & dupl_no==1
replace TOX_X=3 if to_34ff_t2==1 & dupl_no==1
replace TOX_X=4 if to_34ff_t3==1 & dupl_no==1
replace TOX_X=5 if to_educue==1 & dupl_no==2
replace TOX_X=6 if to_educpens==1 & dupl_no==2
replace TOX_X=7 if to_famue==1 & dupl_no==2
replace TOX_X=8 if to_fampens==1 & dupl_no==2
replace TOX_X=9 if to_3801ff_inv==1 & dupl_no==3
replace TOX_X=10 if to_3801ff_pass==1 & dupl_no==3
recode TOX_X (0=.)

*materialistic loser variable, fiscal & policy trade-offs:
gen si_lose_to123=0
replace si_lose_to123=1 if (hhincome==5) & to_merged34ff!=. & Q35bin!=. & dupl_no==1
replace si_lose_to123=1 if (currentsitv3==3 | age50s==1 | age60s==1) & to_merged34ff!=. & Q36bin!=. & dupl_no==1
replace si_lose_to123=1 if (hhincome==5) & to_merged34ff!=. & Q37bin!=. & dupl_no==1
replace si_lose_to123=1 if (currentsitv3==1 | unemplrisk_dummy==1) & Q51dum!=. & to_merged!=. & dupl_no==2
replace si_lose_to123=1 if (currentsitv3==3 | age50s==1 | age60s==1) & Q52dum!=. & to_merged!=. & dupl_no==2
replace si_lose_to123=1 if (currentsitv3==1 | unemplrisk_dummy==1) & Q53dum!=. & to_merged!=. & dupl_no==2
replace si_lose_to123=1 if (currentsitv3==3 | age50s==1 | age60s==1) & Q54dum!=. & to_merged!=. & dupl_no==2
replace si_lose_to123=1 if (currentsitv3==1 | currentsitv3==3 | unemplrisk_dummy==1 | age50s==1 | age60s==1) & socinv!=. & to_merged3801ff!=. & dupl_no==3
replace si_lose_to123=1 if (smallkids_dummy==1 | oldkids_dummy==1 | currentsitv3==2) & passwfs!=. & to_merged3801ff!=. & dupl_no==3

*recode variables not indicating status as materialistic loser in trade-offs
gen hhincome5_else=hhincome5
replace hhincome5_else=0 if TOX_X==2 | TOX_X==4
gen currentsitv3_1_ue_else=currentsitv3_1_ue
replace currentsitv3_1_ue_else=0 if (TOX_X==5 | TOX_X==7 |   TOX_X==9 | TOX_X==10)
gen currentsitv3_3_ret_else=currentsitv3_3_ret
replace currentsitv3_3_ret_else=0 if (TOX_X==3 | TOX_X==6 | TOX_X==8 |   TOX_X==9 | TOX_X==10)
gen age50s_else=age50s 
replace age50s_else=0 if (TOX_X==3 | TOX_X==6 | TOX_X==8 |   TOX_X==9 | TOX_X==10)
gen age60s_else=age60s
replace age60s_else=0 if (TOX_X==3 | TOX_X==6 | TOX_X==8 |   TOX_X==9 | TOX_X==10)
gen unemplrisk_dummy_else=unemplrisk_dummy
replace unemplrisk_dummy_else=0 if (TOX_X==5 | TOX_X==7 |   TOX_X==9 | TOX_X==10)

*ideological loser variable, fiscal & policy trade-offs:
gen ideo_lose=lire_cat
recode ideo_lose (1 2=0) 
replace ideo_lose=1 if lire_left==1 &  (TOX_X==3 | TOX_X==5 | TOX_X==6 | TOX_X==7 | TOX_X==8 | TOX_X==9)
replace ideo_lose=1 if lire_right==1 & (TOX_X==2 | TOX_X==4)

*materialistic loser variable, policy trade-offs:
gen policy_lose_to123=0
replace policy_lose_to123=1 if (currentsitv3==3 | age60s==1) & to_merged34ff!=. & Q36bin!=. & dupl_no==1
replace policy_lose_to123=1 if (currentsitv3==1 ) & Q51dum!=. & to_merged!=. & dupl_no==2
replace policy_lose_to123=1 if (currentsitv3==3  | age60s==1) & Q52dum!=. & to_merged!=. & dupl_no==2
replace policy_lose_to123=1 if (currentsitv3==1 ) & Q53dum!=. & to_merged!=. & dupl_no==2
replace policy_lose_to123=1 if (currentsitv3==3 | age60s==1) & Q54dum!=. & to_merged!=. & dupl_no==2
replace policy_lose_to123=1 if (currentsitv3==1 | currentsitv3==3 | age60s==1) & socinv!=. & to_merged3801ff!=. & dupl_no==3
replace policy_lose_to123=1 if (smallkids_dummy==1 | oldkids_dummy==1 | currentsitv3==2) & passwfs!=. & to_merged3801ff!=. & dupl_no==3

*materialistic loser variable, fiscal trade-offs:
gen fiscal_lose_to123=0
replace fiscal_lose_to123=1 if (hhincome==5) & to_merged34ff!=. & Q35bin!=. & dupl_no==1
replace fiscal_lose_to123=1 if (hhincome==5) & to_merged34ff!=. & Q37bin!=. & dupl_no==1

*to test for influence of missing values
gen mar_check_inc=hhincome
recode mar_check_inc (1 2 3 4 5=0)(.=1)
gen mar_check_lire=lire_cat
recode mar_check_lire (0 1 2=0)(.=1)
gen hhincome_mi=hhincome
replace hhincome_mi=6 if mar_check_inc==1
gen lire_cat_mi=lire_cat
replace lire_cat_mi=3 if mar_check_lire==1


**************************************************************************
*analysis (replication): 
**************************************************************************

**************************************************************************
*Figure 1: Direct effects of government satisfaction on attitudes towards ten different reform scenarios
*Table A.5: Regression table – effect of government satisfaction on 10 reform scenarios (Study 1)
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==1 & Q34bin!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to1_m1
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==1 & Q35bin!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to1_m2
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==1 & Q36bin!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to1_m3
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==1 & Q37bin!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to1_m4
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==2 & Q51dum!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to2_m1
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==2 & Q52dum!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to2_m2
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==2 & Q53dum!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to2_m3
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==2 & Q54dum!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to2_m4
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==3 & socinv!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side 
 margins, dydx(poltrust) post
 est store to3_m1
melogit to_merged123 ib3.educlevel_trans ib3.hhincome   female  kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy i.nradults_dum    poltrust  if dupl_no==3 & passwfs!=. ||COUNTRYCODE:
 outreg2 using reg280317c, dec(2) stats(coef se pval) noaster noparen side excel
 margins, dydx(poltrust) post
 est store to3_m2
coefplot to1_m1 to1_m2 to1_m4 to1_m3 to2_m1 to2_m2 to2_m3 to2_m4 to3_m1 to3_m2, keep(poltrust) xline(0) name(Fig1, replace) legend(rows(5)) ytitle("Marginal effect of governmental trust") ylabel("") ///
 plotlabel( "No constraints"  "Education vs. higher taxes" "Education vs. higher debt" "Education vs. pensions" ///
 "Education vs. unempl. benefits" "Education vs. pensions" "Family policies vs. unempl. benefits" "Family policies vs. pensions" ///
 "Social investm. vs. pass. transfers" "Pass. transfers vs. social investm.") scheme (s1mono)		
**************************************************************************

**************************************************************************
*Table 1: Support for welfare reforms in policy trade-offs
*Table A.6: Regression table – all trade-off questions pooled (Study 1)
*M1
melogit to_merged123 /// 
 poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 ||COUNTRYCODE: ||ID: 
outreg2 using reg060421_polTO, dec(2) stats(coef se pval) noaster noparen side replace
margins,dydx(poltrust)
margins,at(poltrust=(1 5))
*M2
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123)  ///
 ||COUNTRYCODE: ||ID: 
outreg2 using reg060421_polTO, dec(2) stats(coef se pval) noaster noparen side 
margins,at(poltrust=(1 5))
*M3
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat gvtpartyvoter poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) ///
 ||COUNTRYCODE: ||ID: 
outreg2 using reg060421_polTO, dec(2) stats(coef se pval) noaster noparen side 
margins,at(poltrust=(1 5))
*M4
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome   female kids_dum currentsitv3_2_stud    currentsitv3_9_oth age20s age40s age50s i.nradults_dum /// 
  currentsitv3_1_ue_else  currentsitv3_3_ret_else age60s_else unemplrisk_dummy ///
 i.policy_lose_to123##c.poltrust ///
 ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age60s_else, si_lose_to123) /// 
 ||COUNTRYCODE: ||ID: 
outreg2 using reg060421_polTO, dec(2) stats(coef se pval) noaster noparen side 
margins,at(poltrust=(1 5) policy_lose_to123=(0 1)) post
test 1._at = 3._at
test 2._at = 4._at
*M5
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum   ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  gvtpartyvoter i.ideo_lose##c.poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, lire_cat) /// 
 ||COUNTRYCODE: ||ID:   
outreg2 using reg060421_polTO, dec(2) stats(coef se pval) noaster noparen side excel
margins,at(poltrust=(1 5) ideo_lose=(0 1)) post
test 1._at = 3._at
test 2._at = 4._at
**************************************************************************

**************************************************************************
*Figure 2: Interaction effects between government satisfaction and materialistic costs (left side) and ideological costs (right side)
*I.material
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome   female kids_dum currentsitv3_2_stud    currentsitv3_9_oth age20s age40s age50s i.nradults_dum /// 
  currentsitv3_1_ue_else  currentsitv3_3_ret_else age60s_else unemplrisk_dummy ///
 i.policy_lose_to123##c.poltrust ///
 ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age60s_else, si_lose_to123) /// 
 ||COUNTRYCODE: ||ID: 
margins i(0 1).policy_lose_to123, at(poltrust=(1(1)5)) post
est store model0_0
marginsplot, name(Fig1a, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Materialistic costs") xtitle("Governmental trust")  legend(rows(2)) ///
 addplot( ///
 normal  poltrust if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age60s_else, si_lose_to123),  yaxis(2) yscale(alt axis(2)) ytitle("Density of political trust", axis(2)) xlabel(1 (1) 5) lpattern(dot) lcolor(gs10) below ///
 )
*II.ideological: 
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum   ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  gvtpartyvoter i.ideo_lose##c.poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, lire_cat) /// 
 ||COUNTRYCODE: ||ID:  
margins i(0 1).ideo_lose, at(poltrust=(1(1)5)) post 
est store model1_1
marginsplot, name(Fig1b, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Ideological costs") xtitle("Governmental trust")  legend(rows(2)) ///
 addplot( ///
 normal  poltrust if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, lire_cat),  yaxis(2) yscale(alt axis(2)) ytitle("Density of political trust", axis(2)) xlabel(1 (1) 5) lpattern(dot) lcolor(gs10) below ///
 )
graph combine Fig1a Fig1b, scheme(s1mono) ycommon xcommon rows(1) name(Fig1_polTO, replace) title("Policy trade-offs") 
**************************************************************************

**************************************************************************
*Table A.2: Comparison of our dataset (Inveduc) to the European Social Survey (ESS)
mean age if dupl_no==1, over (countryno)
svy: mean  age if dupl_no==1, over (countryno)
mean female if dupl_no==1, over (countryno)
svy: mean  female if dupl_no==1, over (countryno)
mean currentsitv3_1_ue if dupl_no==1, over (countryno)
svy: mean  currentsitv3_1_ue if dupl_no==1, over (countryno)
mean currentsitv3_2_stud if dupl_no==1, over (countryno)
svy: mean  currentsitv3_2_stud if dupl_no==1, over (countryno)
mean currentsitv3_3_ret if dupl_no==1, over (countryno)
svy: mean  currentsitv3_3_ret if dupl_no==1, over (countryno)
mean currentsitv3_6_work if dupl_no==1, over (countryno)
svy: mean  currentsitv3_6_work if dupl_no==1, over (countryno)
**************************************************************************

**************************************************************************
*Table A.3: Balance test for the split-sample questions, checking the randomization
svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==1 & Q34bin!=.
svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==1 & Q35bin!=.
svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==1 & Q36bin!=.
svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==1 & Q37bin!=.

svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==2 & Q51dum!=.
svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==2 & Q52dum!=.
svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==2 & Q53dum!=.
svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==2 & Q54dum!=.

svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==3 & socinv!=.
svy: mean  educlevel_trans hhincome  female kids_dum  currentsitv3_1_ue currentsitv3_2_stud currentsitv3_3_ret currentsitv3_6_work currentsitv3_9_oth age unemplrisk_dummy nradults_dum lire_cat gvtpartyvoter poltrust if !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) & dupl_no==3 & passwfs!=.
**************************************************************************

**************************************************************************
*Table A.4: List of question wording and descriptive statistics for all variables for Study 1
sum to_merged123 educlevel_trans hhincome female kids_dum currentsitv3 age unemplrisk_dummy nradults_dum poltrust lire_cat gvtpartyvoter genspend si_lose_to123 ideo_lose if TOX_X!=1 & TOX_X!=10 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123) 
**************************************************************************

**************************************************************************
*Table A.7: Regression table – robustness test: including vote intention for the incumbent government (and its interaction with government satisfaction) (Study 1)
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat gvtpartyvoter ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) ///
 ||COUNTRYCODE: ||ID: 
 outreg2 using reg140421pollose, dec(2) stats(coef se pval) noaster noparen side replace
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat i.gvtpartyvoter##c.poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) ///
 ||COUNTRYCODE: ||ID: 
 outreg2 using reg140421pollose, dec(2) stats(coef se pval) noaster noparen side excel
margins,dydx(poltrust) at(gvtpartyvoter=(0 1))
**************************************************************************

**************************************************************************
*Table A.8: Regressions by country (Study 1), pooled policy trade-offs
forvalues k=1/7 {
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & countryno==`k' & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123)  ///
 ||ID:  
 outreg2 using reg280317e, dec(2) stats(coef se pval) noaster noparen side  
}
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & countryno==8 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123)  ///
 ||ID:  
 outreg2 using reg280317e, dec(2) stats(coef se pval) noaster noparen side  excel
**************************************************************************

**************************************************************************
*Table A.11: Regression table – robustness test: including country fixed effects (Study 1)
logit to_merged123 /// 
 poltrust ib9.TOX_X i.COUNTRYCODE if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 ,vce(cluster ID) 
outreg2 using reg140421_polTO_FE, dec(2) stats(coef se pval) noaster noparen side replace
logit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum poltrust ib9.TOX_X i.COUNTRYCODE if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123)  ///
  ,vce(cluster ID) 
outreg2 using reg140421_polTO_FE, dec(2) stats(coef se pval) noaster noparen side 
logit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat gvtpartyvoter poltrust ib9.TOX_X i.COUNTRYCODE if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) ///
  ,vce(cluster ID)  
outreg2 using reg140421_polTO_FE, dec(2) stats(coef se pval) noaster noparen side 
logit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome   female kids_dum currentsitv3_2_stud    currentsitv3_9_oth age20s age40s age50s i.nradults_dum /// 
  currentsitv3_1_ue_else  currentsitv3_3_ret_else age60s_else unemplrisk_dummy ///
 i.policy_lose_to123##c.poltrust ///
 ib9.TOX_X i.COUNTRYCODE if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age60s_else, si_lose_to123) /// 
  ,vce(cluster ID)  
outreg2 using reg140421_polTO_FE, dec(2) stats(coef se pval) noaster noparen side 
logit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum   ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  gvtpartyvoter i.ideo_lose##c.poltrust ib9.TOX_X i.COUNTRYCODE if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, lire_cat) /// 
  ,vce(cluster ID)   
outreg2 using reg140421_polTO_FE, dec(2) stats(coef se pval) noaster noparen side excel
**************************************************************************

**************************************************************************
*Table A.13: Regression table – robustness test: testing for the influence of missing values (Study 1)
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome_mi  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat_mi gvtpartyvoter poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) ///
 ||COUNTRYCODE: ||ID: 
outreg2 using reg140421_polTO_missings, dec(2) stats(coef se pval) noaster noparen side replace
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome_mi##c.poltrust  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat_mi gvtpartyvoter  ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) ///
 ||COUNTRYCODE: ||ID: 
outreg2 using reg140421_polTO_missings, dec(2) stats(coef se pval) noaster noparen side 
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome_mi  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat_mi##c.poltrust gvtpartyvoter  ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) ///
 ||COUNTRYCODE: ||ID:  
outreg2 using reg140421_polTO_missings, dec(2) stats(coef se pval) noaster noparen side excel
**************************************************************************

**************************************************************************
*Table A.14: Regression table – all fiscal trade-off questions pooled (Study 1)
melogit to_merged123 /// 
 poltrust ib2.TOX_X if (TOX_X==2 | TOX_X==4) ||COUNTRYCODE: 
outreg2 using reg060421_fiscTO, dec(2) stats(coef se pval) noaster noparen side replace
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum poltrust ib2.TOX_X if (TOX_X==2 | TOX_X==4) & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123)  ///
 ||COUNTRYCODE: 
outreg2 using reg060421_fiscTO, dec(2) stats(coef se pval) noaster noparen side 
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat gvtpartyvoter poltrust ib2.TOX_X if (TOX_X==2 | TOX_X==4) & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) ///
 ||COUNTRYCODE: 
outreg2 using reg060421_fiscTO, dec(2) stats(coef se pval) noaster noparen side 
melogit to_merged123 /// 
 ib3.educlevel_trans hhincome1 hhincome2 hhincome4   female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall i.nradults_dum /// 
      unemplrisk_dummy ///
 i.fiscal_lose_to123##c.poltrust ///
 ib2.TOX_X if (TOX_X==2 | TOX_X==4) & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123) /// 
 ||COUNTRYCODE: 
outreg2 using reg060421_fiscTO, dec(2) stats(coef se pval) noaster noparen side 
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum   ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  gvtpartyvoter i.ideo_lose##c.poltrust ib2.TOX_X if (TOX_X==2 | TOX_X==4) & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, lire_cat) /// 
 ||COUNTRYCODE:  
outreg2 using reg060421_fiscTO, dec(2) stats(coef se pval) noaster noparen side excel
margins i(0 1).ideo_lose, at(poltrust=(1 5)) post 
test 1._at#0.ideo_lose = 1._at#1.ideo_lose
**************************************************************************

**************************************************************************
*Table A.15: Regression table - robustness test: test for nonlinear interaction effects (Study 1)
*Figure A.1: Predicted probabilities - robustness test: test for nonlinear interaction effects (Study 1)
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome   female kids_dum currentsitv3_2_stud    currentsitv3_9_oth age20s age40s age50s i.nradults_dum /// 
  currentsitv3_1_ue_else  currentsitv3_3_ret_else age60s_else unemplrisk_dummy ///
 i.policy_lose_to123##c.poltrust##c.poltrust ///
 ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age60s_else, si_lose_to123) /// 
 ||COUNTRYCODE: ||ID:
outreg2 using reg140421squarediact, dec(2) stats(coef se pval) noaster noparen side replace 
margins i(0 1).policy_lose_to123, at(poltrust=(1(1)5)) post
est store model0_0
marginsplot, name(Fig1a, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Materialistic costs") xtitle("Governmental trust")  legend(rows(2)) 
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum   ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  gvtpartyvoter i.ideo_lose##c.poltrust##c.poltrust ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, lire_cat) /// 
 ||COUNTRYCODE: ||ID:  
outreg2 using reg140421squarediact, dec(2) stats(coef se pval) noaster noparen side excel 
margins i(0 1).ideo_lose, at(poltrust=(1(1)5)) post 
est store model1_1
marginsplot, name(Fig1b, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Ideological costs") xtitle("Governmental trust")  legend(rows(2)) 
graph combine Fig1a Fig1b, scheme(s1mono) ycommon xcommon rows(1) name(Fig1_polTO_sq, replace) title("Policy trade-offs") 
**************************************************************************

**************************************************************************
*Table A.16: Regression table - robustness test: including attitudinal control variables (Study 1)
*Figure A.2: Predicted probabilities – robustness test: policy trade-offs, including attitudinal control variables (Study 1)
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome   female kids_dum currentsitv3_2_stud    currentsitv3_9_oth age20s age40s age50s i.nradults_dum /// 
  currentsitv3_1_ue_else  currentsitv3_3_ret_else age60s_else unemplrisk_dummy ib1.lire_cat gvtpartyvoter ///
 i.policy_lose_to123##c.poltrust ///
 ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age60s_else, si_lose_to123) /// 
 ||COUNTRYCODE: ||ID: 
outreg2 using reg140421attC, dec(2) stats(coef se pval) noaster noparen side replace excel
margins i(0 1).policy_lose_to123, at(poltrust=(1(1)5)) post
est store model0_0
marginsplot, name(Fig1a_wattc, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Materialistic costs") xtitle("Governmental trust")  legend(rows(2)) 
*M2: control also for genspend
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome   female kids_dum currentsitv3_2_stud    currentsitv3_9_oth age20s age40s age50s i.nradults_dum /// 
  currentsitv3_1_ue_else  currentsitv3_3_ret_else age60s_else unemplrisk_dummy ib1.lire_cat gvtpartyvoter ///
 i.policy_lose_to123##c.poltrust genspend ///
 ib9.TOX_X if TOX_X!=1 & TOX_X!=10 & TOX_X!=2 & TOX_X!=4 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age60s_else, si_lose_to123) /// 
 ||COUNTRYCODE: ||ID: 
outreg2 using reg140421attC_socspend, dec(2) stats(coef se pval) noaster noparen side replace excel
**************************************************************************

**************************************************************************
*Table A.18: Regression table – tax and debt trade-off questions (Study 1)
*Figure A.3: Predicted probabilities - robustness test: support for reform under tax and debt trade-off conditions (Study 1)
*taxes
melogit to_merged123 /// 
 ib3.educlevel_trans hhincome1 hhincome2 hhincome4   female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall i.nradults_dum /// 
      unemplrisk_dummy ///
 i.fiscal_lose_to123##c.poltrust ///
 if (TOX_X==2) & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123) /// 
 ||COUNTRYCODE: 
outreg2 using reg160421_fiscTOsep, dec(2) stats(coef se pval) noaster noparen side replace
margins i(0 1).fiscal_lose_to123, at(poltrust=(1(1)5)) post
est store model0_0
marginsplot, name(Fig1a, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Materialistic costs") xtitle("Government satisfaction")  legend(rows(2)) 
 melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum   ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  gvtpartyvoter i.ideo_lose##c.poltrust if (TOX_X==2) & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, lire_cat) /// 
 ||COUNTRYCODE:  
outreg2 using reg160421_fiscTOsep, dec(2) stats(coef se pval) noaster noparen side 
margins i(0 1).ideo_lose, at(poltrust=(1(1)5)) post 
est store model1_1
marginsplot, name(Fig1b, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Ideological costs") xtitle("Government satisfaction")  legend(rows(2)) 
*Figure tax TO: pred probs
graph combine Fig1a Fig1b, scheme(s1mono) ycommon xcommon rows(1) name(Fig1_taxTO, replace) title("Tax trade-off") 
*debt
melogit to_merged123 /// 
 ib3.educlevel_trans hhincome1 hhincome2 hhincome4   female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall i.nradults_dum /// 
      unemplrisk_dummy ///
 i.fiscal_lose_to123##c.poltrust ///
  if ( TOX_X==4) & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust) /// 
 & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, hhincome5_else, currentsitv3_1_ue_else, currentsitv3_3_ret_else, age50s_else, age60s_else, unemplrisk_dummy_else, si_lose_to123) /// 
 ||COUNTRYCODE: 
outreg2 using reg160421_fiscTOsep, dec(2) stats(coef se pval) noaster noparen side 
margins i(0 1).fiscal_lose_to123, at(poltrust=(1(1)5)) post
est store model2_2
marginsplot, name(Fig1a, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Materialistic costs") xtitle("Government satisfaction")  legend(rows(2)) 
melogit to_merged123 /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum   ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum  gvtpartyvoter i.ideo_lose##c.poltrust  if ( TOX_X==4) & !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust, lire_cat) /// 
 ||COUNTRYCODE: 
outreg2 using reg160421_fiscTOsep, dec(2) stats(coef se pval) noaster noparen side excel
margins i(0 1).ideo_lose, at(poltrust=(1(1)5)) post 
est store model3_3
marginsplot, name(Fig1b, replace) scheme(s1mono) recast(line) ciopts(recast(rline) lpattern(dash)) title("Ideological costs") xtitle("Government satisfaction")  legend(rows(2)) 
*Figure debt TO: pred probs
graph combine Fig1a Fig1b, scheme(s1mono) ycommon xcommon rows(1) name(Fig1_debtTO, replace) title("Debt trade-off") 
graph combine Fig1_taxTO Fig1_debtTO, scheme(s1mono) ycommon xcommon rows(1) name(Fig1_2fiscTO, replace) 
**************************************************************************

**************************************************************************
*Table A.22: Regression table – Consistency check for the two education vs. pensions trade-offs (Study 1)
*0: reject both TOs, 1: accept only "soft" TO ,2: accept only "hard" TO , 3: accept both TOs
gen conscheck_educpens=.
replace conscheck_educpens=0 if Q36bin==0 & Q52dum==0
replace conscheck_educpens=1 if Q36bin==1 & Q52dum==0
replace conscheck_educpens=2 if Q36bin==0 & Q52dum==1
replace conscheck_educpens=3 if Q36bin==1 & Q52dum==1
mlogit conscheck_educpens /// 
 ib3.educlevel_trans ib3.hhincome  female kids_dum  ib6.currentsitv3 age20sall age40sall age50sall age60sall unemplrisk_dummy ///
 i.nradults_dum ib1.lire_cat gvtpartyvoter poltrust i.COUNTRYCODE  if  !missing(educlevel_trans, hhincome, female, kids_dum, currentsitv3, age, unemplrisk_dummy, nradults_dum, poltrust), base(3) 
outreg2 using reg280721_conscheck, dec(2) stats(coef se pval) noaster noparen side excel
**************************************************************************


