### Reproducible Code: The Effect of Women's Representation on Renewable Energy Policy Outcomes

install.packages(gplots)
library(gplots)
install.packages(dplyr)
library(dplyr)
install.packages(ggplot2)
library(ggplot2)
install.packages(plm)
library(plm)
install.packages(stargazer)
library(stargazer)
install.packages(interplot)
library(interplot)
dev.off()

# Datasets: 

### All data un-aggregated by election term. Used in plotting heterogeneity and distributions.
AllData<-read.csv(".../Reproducible Code DataSets/CompleteOriginalData.csv")
view(AllData)

### Data used in regressions, aggregated by election term.
Data<-read.csv(".../Reproducible Code DataSets/Data.csv")
Data<-pdata.frame(Data, index=c("Country", "ElectionTerm"))
view(Data)

### Dataset including Manifesto Project Data for regressions included in the online appendix.
NewData<-read.csv(".../Reproducible Code DataSets/DataPartyPositionFixed.csv")
view(NewData)
NewData<-pdata.frame(NewData, index=c("Country", "ElectionTerm"))

### Data on women in cabinets included in this dataset and also used in some online appendix regressions.
EJPRData<-read.csv(".../Reproducible Code DataSets/EJPRData.csv")
view(EJPRData)
EJPRData<-pdata.frame(EJPRData, index=c("Country", "ElectionTerm"))
#_______________________________________________________________________________________________________

### Checking how many years per election term on average (referenced in manuscript pp. 16)
table(AllData$ElectionTerm)
table(AllData$Country)
##Election Terms
##1   2   3   4   5   6   7   8   9  10  11 
##300 439 411 366 283 157  59  16   8   5   3
## Countries: 108

### Checking increases in women's representation and renewable energy consumption across the sample period (referenced in manuscript pp. 24-25.)
AllData<-AllData[!(AllData$Year=="2017"),]
view(AllData)
library(dplyr)

MinYear<- 
  AllData %>%
  group_by(Country)%>%
  slice(which.min(Year))
view(MinYear)

MaxYear<- 
  AllData %>%
  group_by(Country)%>%
  slice(which.max(Year))
view(MaxYear)

MaxYear<-rename(MaxYear, WomenMax=WomenParl)
MinYear<-rename(MinYear, WomenMin=WomenParl)
MaxYear$WomenChange<-(MaxYear$WomenMax - MinYear$WomenMin)
summary(MaxYear$WomenChange)
## Women's rep increased the most in Ecuador by over 30 percent
#___________________________________________________________________________
Renewables<-AllData[!(AllData$Year=="2016"),]
Renewables<-AllData[!(AllData$Year=="2017"),]
view(Renewables)
MinRen<- 
  Renewables %>%
  group_by(Country)%>%
  slice(which.min(Year))
view(MinRen)

MaxRen<- 
  Renewables %>%
  group_by(Country)%>%
  slice(which.max(Year))
view(MaxRen)

MaxRen<-rename(MaxRen, RenMax=RenEnCon)
MinRen<-rename(MinRen, RenMin=RenEnCon)
MaxRen$RenChange<-(MaxRen$RenMax - MinRen$RenMin)

summary(MaxRen$RenChange)
view(MaxRen)
## RenEnCon increased the most in Denmark, by 25%, where women in parliament increased by 4%. Ecuador's renewables dropped by 2.5%,
## where women's representation increased by over 30%
summary(MaxYear$WomenChange)
## Average change from 2016 to earliest in women's rep is 9.644.
summary(MaxRen$RenChange)
## Average change from 2015 to earliest in REC is -0.536. 
## So, on average women's rep is increasing, while REC is decreasing. 
#________________________________________________________________________________________________________


### Graphing/Visualizing (find in mansucript pp. 22-25).
# Heterogeneity: using AllData dataset which is not aggregated by election term.

## Dependent Variable
plotmeans(RenEnCon~Year, main="Heterogeneity across election terms", ylab = "Renewable Energy Consumption", data = AllData)

## Independent Variable 
plotmeans(WomenParl~Year, main="Heterogeneity across election terms", ylab = "Percent Women in Parliament",xlab = "Election Term", data = AllData)

### Women in Parliament: broken down by income
AllData$Income.Group<-factor(AllData$Income.Group, levels = c("High income", "Upper middle income", "Lower middle income", "Low income"))
AllData %>% ggplot(aes(x = WomenParl)) + geom_density(aes(linetype =Income.Group))+ 
  labs(col="Income Group", title = "Distribution of Share of Women in Parliaments by Income Group", 
       x="Percent of Parliaments Made Up of Women", y="Density")
### Women in Parliament: All
AllData %>% ggplot(aes(x = WomenParl)) +geom_density(fill="grey", color="black", alpha=0.8)+
  labs(title = "Distribution of Share of Women in Parliaments", 
       x="Percent of Parliaments Made Up of Women", y="Density")
### Renewable Energy Consumption: broken down by income 
AllData %>% ggplot(aes(x = RenEnCon)) + geom_density(aes(linetype =Income.Group))+
  labs(col="Income Group", title = "Distribution of Renewable Energy Consumption by Income Group", 
       x="Renewable Energy Consumption as % of Total Energy Consumption", y="Density")

### Renewable Energy Consumption: All
AllData %>% ggplot(aes(x = RenEnCon)) +geom_density(fill="grey", color="black", alpha=0.8)+
  labs(title = "Distribution of Renewable Energy Consumption", 
       x="Renewable Energy Consumption as % of Total Energy Consumption", y="Density")

#________________________________________________________________________________________________________
##Looking at Variables: Stationary?
adf.test(na.omit(AllData$RenEnCon))
adf.test(na.omit(AllData$WomenParl))
adf.test(na.omit(AllData$GDPpercap))
adf.test(na.omit(AllData$HDI))
adf.test(na.omit(AllData$Vulnerability))
adf.test(na.omit(AllData$ResourceRents))
###All stationary (p-values below .05)
#________________________________________________________________________________________________________
### Regressions

### Table 1: Interaction of Women in Parliament and GDP per capita

Interaction1<-plm(log(RenEnCon+1)~WomenParl*log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.action=na.omit)
summary(Interaction1)
pbgtest(Interaction1) ##Low p-value, autocorrelation 
coeftest(Interaction1, vcov(Interaction1, method="arellano"))

Interaction2<-plm(log(RenEnCon+1)~lag(WomenParl, 1)*log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.action=na.omit)
summary(Interaction2)
pbgtest(Interaction2) ##Low p-value, autocorrelation 
coeftest(Interaction2, vcov(Interaction2, method="arellano"))

Interaction3<-plm(log(RenEnCon+1)~lag(WomenParl, 2)*log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.action=na.omit)
summary(Interaction3)
pbgtest(Interaction3) ## No autocorrelation 

Interaction4<-plm(log(RenEnCon+1)~lag(WomenParl, 3)*log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.action=na.omit)
summary(Interaction4)
pbgtest(Interaction4) ##no autocorrelation 

stargazer(Interaction1, Interaction2, Interaction3, Interaction4, title = "Interaction of Women in Parliament and GDP per capita", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags","log GDP per capita", 
                               "Vulnerability", "Resource Rents", "Freedom House Score", "HDI", "Women in Parliament x GDP per capita", "1 Lag Women in Parliament x GDP per capita", 
                               "2 Lags Women in Parliament x GDP per capita", "3 Lags Women in Parliament x GDP per capita"), notes.label="Significance levels", type = "html", out="NewModelsInteractions.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))

### For plotting marginal effects with interplot

Data$logGDP <- log(Data$GDPpercap)
Data <- slide(Data, Var = 'WomenParl', NewVar = 'Lag1Women', slideBy = 1)
Data <- slide(Data, Var = 'WomenParl', NewVar = 'Lag2Women', slideBy = 2)
Data <- slide(Data, Var = 'WomenParl', NewVar = 'Lag3Women', slideBy = 3)
Data <- slide(Data, Var = 'WomenParl', NewVar = 'Lag4Women', slideBy = 4)

InteractionPlot1<-lm(log(RenEnCon+1)~WomenParl*logGDP +Vulnerability+ResourceRents+FreedomHouse+HDI + as.factor(ElectionTerm)+ as.factor(Country), data= Data, na.action=na.omit)
summary(InteractionPlot1)

InteractionPlot2<-lm(log(RenEnCon+1)~Lag1Women*logGDP +Vulnerability+ResourceRents+FreedomHouse+HDI + as.factor(ElectionTerm) + as.factor(Country), data= Data, na.action=na.omit)
summary(InteractionPlot2)

InteractionPlot3<-lm(log(RenEnCon+1)~Lag2Women*logGDP +Vulnerability+ResourceRents+FreedomHouse+HDI + as.factor(ElectionTerm) + as.factor(Country), data= Data, na.action=na.omit)
summary(Interaction3)

InteractionPlot4<-lm(log(RenEnCon+1)~Lag3Women*logGDP +Vulnerability+ResourceRents+FreedomHouse+HDI + as.factor(ElectionTerm) + as.factor(Country), data= Data,na.action=na.omit)
summary(Interaction4)

interplot(m=InteractionPlot1, var1="WomenParl", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for Percent of Women in Parliaments")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=InteractionPlot2, var1="Lag1Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 1 Election term Lag of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 1 lag, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=InteractionPlot3, var1="Lag2Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 2 Election term Lags of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 2 lags, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=InteractionPlot4, var1="Lag3Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 3 Election term Lags of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 3 lags, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))


## Appendix Table 1: Women in Parliament effect on Renewable Consumption, no interaction
Regression1<-plm(log(RenEnCon+1)~WomenParl+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.action=na.omit)
summary(Regression1)
pbgtest(Regression1) ##Low p-value, autocorrelation 
coeftest(Regression1, vcov(Regression1, method="arellano"))

Regression2<-plm(log(RenEnCon+1)~lag(WomenParl, 1)+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.action=na.omit)
summary(Regression2)
pbgtest(Regression2) ##Low p-value, autocorrelation 
coeftest(Regression2, vcov(Regression2, method="arellano"))

Regression3<-plm(log(RenEnCon+1)~lag(WomenParl, 2)+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.action=na.omit)
summary(Regression3)
pbgtest(Regression3) ##Low p-value, autocorrelation 
coeftest(Regression3, vcov(Regression3, method="arellano"))

Regression4<-plm(log(RenEnCon+1)~lag(WomenParl, 3)+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.action=na.omit)
summary(Regression4)
pbgtest(Regression4) ##No autocorrelation 

Regression5<-plm(log(RenEnCon+1)~lag(WomenParl, 4)+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= Data, model = "within", effect = "twoways", na.rm=TRUE)
summary(Regression5)
pbgtest(Regression5) ##No autocorrelation 

stargazer(Regression1,Regression2,Regression3,Regression4,Regression5, title = "All Democracies", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags","Women in Parliament, 4 lags","log GDP per capita", 
                               "Vulnerability", "Resource Rents", "Freedom House Score", "HDI"), notes.label="Significance levels", type = "html", out="NewModels1.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))


# Appendix Table 2: Interaction of Women in Parliament and Democracy Score 
Democracy1<-lm(log(RenEnCon+1)~WomenParl*FreedomHouse+logGDP+ Vulnerability+ResourceRents+HDI + as.factor(ElectionTerm)+ as.factor(Country), data= Data, na.action=na.omit)
summary(Democracy1)
bgtest(Democracy1) ##Low p-value, autocorrelation 
coeftest(Democracy1, vcov(Democracy1, method="arellano"))

Democracy2<-lm(log(RenEnCon+1)~Lag1Women*FreedomHouse+ logGDP +Vulnerability+ResourceRents+HDI + as.factor(ElectionTerm) + as.factor(Country), data= Data, na.action=na.omit)
summary(Democracy2)
bgtest(Democracy2) ##Low p-value, autocorrelation 
coeftest(Democracy2, vcov(Democracy2, method="arellano"))

Democracy3<-lm(log(RenEnCon+1)~Lag2Women*FreedomHouse+ logGDP +Vulnerability+ResourceRents+HDI + as.factor(ElectionTerm) + as.factor(Country), data= Data, na.action=na.omit)
summary(Democracy3)
bgtest(Democracy3) ##Low p-value, autocorrelation 
coeftest(Democracy3, vcov(Democracy3, method="arellano"))

Democracy4<-lm(log(RenEnCon+1)~Lag3Women*FreedomHouse+ logGDP +Vulnerability+ResourceRents+HDI + as.factor(ElectionTerm) + as.factor(Country), data= Data,na.action=na.omit)
summary(Democracy4)
bgtest(Democracy4) ##Low p-value, autocorrelation 
coeftest(Democracy4, vcov(Democracy4, method="arellano"))

stargazer(Democracy1,Democracy2, Democracy3, Democracy4, title = "Interaction of Women in Parliament and Democracy Score", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags","Women in Parliament, 4 lags","log GDP per capita", 
                               "Vulnerability", "Resource Rents", "HDI", "Women in Parliament x Democracy", "1 Lag Women in Parliament x Democracy", 
                               "2 Lags Women in Parliament x Democracy", "3 Lags Women in Parliament x Democracy"), notes.label="Significance levels", type = "html", out="Democracy.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))

interplot(m=Democracy1, var1="WomenParl", var2="FreedomHouse", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("Democracy Score")+
  ylab("Estimated Coefficient for Percent of Women in Parliaments")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament on Renewable Energy Consumption by Democracy Score")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=Democracy2, var1="Lag1Women", var2="FreedomHouse", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("Democracy Score")+
  ylab("Estimated Coefficient for 1 Election term Lag of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 1 lag, on Renewable Energy Consumption by Democracy Score")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=Democracy3, var1="Lag2Women", var2="FreedomHouse", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("Democracy Score")+
  ylab("Estimated Coefficient for 2 Election term Lags of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 2 lags, on Renewable Energy Consumption by Democracy Score")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=Democracy4, var1="Lag3Women", var2="FreedomHouse", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("Democracy Score")+
  ylab("Estimated Coefficient for 3 Election term Lags of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 3 lags, on Renewable Energy Consumption by Democracy Score")+
  theme(plot.title = element_text(face = "bold"))

# Appendix Table 3: Interaction of Women in Parliament and HDI
HDI1<-lm(log(RenEnCon+1)~WomenParl*HDI +logGDP+ Vulnerability+ResourceRents+FreedomHouse + as.factor(ElectionTerm)+ as.factor(Country), data= Data, na.action=na.omit)
summary(HDI1)
bgtest(HDI1) ##Low p-value, autocorrelation 
coeftest(HDI1, vcov(HDI1, method="arellano"))

HDI2<-lm(log(RenEnCon+1)~Lag1Women*HDI+ logGDP +Vulnerability+ResourceRents+FreedomHouse + as.factor(ElectionTerm) + as.factor(Country), data= Data, na.action=na.omit)
summary(HDI2)
bgtest(HDI2) ##Low p-value, autocorrelation 
coeftest(HDI2, vcov(HDI2, method="arellano"))

HDI3<-lm(log(RenEnCon+1)~Lag2Women*HDI+ logGDP +Vulnerability+ResourceRents+FreedomHouse + as.factor(ElectionTerm) + as.factor(Country), data= Data, na.action=na.omit)
summary(HDI3)
bgtest(HDI3) ##Low p-value, autocorrelation 
coeftest(HDI3, vcov(HDI3, method="arellano"))

HDI4<-lm(log(RenEnCon+1)~Lag3Women*HDI+ logGDP +Vulnerability+ResourceRents+FreedomHouse + as.factor(ElectionTerm) + as.factor(Country), data= Data,na.action=na.omit)
summary(HDI4)
bgtest(HDI4) ##Low p-value, autocorrelation 
coeftest(HDI4, vcov(HDI4, method="arellano"))

stargazer(HDI1,HDI2, HDI3, HDI4, title = "Interaction of Women in Parliament and HDI", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags","Women in Parliament, 4 lags","log GDP per capita", 
                               "Vulnerability", "Resource Rents", "Freedom House Score", "Women in Parliament x HDI", "1 Lag Women in Parliament x HDI", 
                               "2 Lags Women in Parliament x HDI", "3 Lags Women in Parliament x HDI"), notes.label="Significance levels", type = "html", out="HDI.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))

interplot(m=HDI1, var1="WomenParl", var2="HDI", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("HDI")+
  ylab("Estimated Coefficient for Percent of Women in Parliaments")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament on Renewable Energy Consumption by HDI")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=HDI2, var1="Lag1Women", var2="HDI", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("HDI")+
  ylab("Estimated Coefficient for 1 Election term Lag of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 1 lag, on Renewable Energy Consumption by HDI")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=HDI3, var1="Lag2Women", var2="HDI", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("HDI")+
  ylab("Estimated Coefficient for 2 Election term Lags of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 2 lags, on Renewable Energy Consumption by HDI")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=HDI4, var1="Lag3Women", var2="HDI", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("HDI")+
  ylab("Estimated Coefficient for 3 Election term Lags of Percent of Women in Parliament")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 3 lags, on Renewable Energy Consumption by HDI")+
  theme(plot.title = element_text(face = "bold"))


# Appendix Table 4: All Democracies with Government Lean Control

WithGov1<-plm(log(RenEnCon+1)~WomenParl+log(GDPpercap)+Vulnerability+ResourceRents+GovLeftRight+FreedomHouse+HDI, data=NewData , model = "within", effect = "twoways", na.action = na.exclude)
pbgtest(WithGov1)
coeftest(WithGov1, vcov(WithGov1, method="arellano"))
## low p-value: autocorrelation
summary(WithGov1)

WithGov2<-plm(log(RenEnCon+1)~lag(WomenParl)+log(GDPpercap)+Vulnerability+ResourceRents+GovLeftRight+FreedomHouse+HDI, data=NewData, model = "within", effect = "twoways", na.action = na.exclude)
pbgtest(WithGov2)
coeftest(WithGov1, vcov(WithGov1, method="arellano"))
summary(WithGov2)

WithGov3<-plm(log(RenEnCon+1)~lag(WomenParl,2)+log(GDPpercap)+Vulnerability+ResourceRents+GovLeftRight+FreedomHouse+HDI, data= NewData, model = "within", effect = "twoways", na.action = na.exclude)
pbgtest(WithGov3)
summary(WithGov3)

WithGov4<-plm(log(RenEnCon+1)~lag(WomenParl,3)+log(GDPpercap)+Vulnerability+ResourceRents+GovLeftRight+FreedomHouse+HDI, data= NewData, model = "within", effect = "twoways", na.action = na.exclude)
pbgtest(WithGov4)
summary(WithGov4)

WithGov5<-plm(log(RenEnCon+1)~lag(WomenParl,4)+log(GDPpercap)+Vulnerability+ResourceRents+GovLeftRight+FreedomHouse+HDI, data= NewData, model = "within", effect = "twoways", na.action = na.exclude)
pbgtest(WithGov5)
summary(WithGov5)

WithGov6<-plm(log(RenEnCon+1)~lag(WomenParl,5)+log(GDPpercap)+Vulnerability+ResourceRents+GovLeftRight+FreedomHouse+HDI, data= NewData, model = "within", effect = "twoways", na.action = na.exclude)
pbgtest(WithGov6)
summary(WithGov6)

stargazer(WithGov1, WithGov2, WithGov3, WithGov4, title = "All Democracies with Government Lean Control", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags", "log GDP per capita", 
                               "Vulnerability", "Resource Rents","Gov Left-Right Position", "Freedom House Score", "HDI"), notes.label="Significance levels", type = "html", out="NewModelsGovLean6.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))

# Appendix Table 5: Women in parliament x GDP effect on renewables + gov lean control

WithGovInteraction1<-plm(log(RenEnCon+1)~WomenParl*log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI+GovLeftRight, data= NewData, model = "within", effect = "twoways", na.action=na.omit)
summary(WithGovInteraction1)
pbgtest(WithGovInteraction1) ##Low p-value, autocorrelation 
coeftest(WithGovInteraction1, vcov(WithGovInteraction1, method="arellano"))

WithGovInteraction2<-plm(log(RenEnCon+1)~lag(WomenParl, 1)*log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI+GovLeftRight, data= NewData, model = "within", effect = "twoways", na.action=na.omit)
summary(WithGovInteraction2)
pbgtest(WithGovInteraction2) ##No autocorrelation 

WithGovInteraction3<-plm(log(RenEnCon+1)~lag(WomenParl, 2)*log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI+GovLeftRight, data= NewData, model = "within", effect = "twoways", na.action=na.omit)
summary(WithGovInteraction3)
pbgtest(WithGovInteraction3) ##No autocorrelation 

WithGovInteraction4<-plm(log(RenEnCon+1)~lag(WomenParl, 3)*log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI+GovLeftRight, data= NewData, model = "within", effect = "twoways", na.action=na.omit)
summary(WithGovInteraction4)
pbgtest(WithGovInteraction4) ##No autocorrelation 

stargazer(WithGovInteraction1, WithGovInteraction2, WithGovInteraction3, WithGovInteraction4, title = "All Democracies with Government Lean Control", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags", "log GDP per capita", 
                               "Vulnerability", "Resource Rents","Gov Left-Right Position", "Freedom House Score", "HDI"), notes.label="Significance levels", type = "html", out="Testing2.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))


## To Plot Marginal effects
WithGovInteractionPlot1<-lm(log(RenEnCon+1)~WomenParl*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+GovLeftRight+as.factor(ElectionTerm)+ as.factor(Country), data= NewData, na.action=na.omit)
summary(WithGovInteractionPlot1)
bgtest(WithGovInteractionPlot1) ##Low p-value, autocorrelation 
coeftest(WithGovInteractionPlot1, vcov(WithGovInteractionPlot1, method="arellano"))

WithGovInteractionPlot2<-lm(log(RenEnCon+1)~Lag1Women*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+GovLeftRight+as.factor(ElectionTerm)+ as.factor(Country), data= NewData, na.action=na.omit)
summary(WithGovInteractionPlot2)
bgtest(WithGovInteractionPlot2) ##No autocorrelation 

WithGovInteractionPlot3<-lm(log(RenEnCon+1)~Lag2Women*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+GovLeftRight+as.factor(ElectionTerm)+ as.factor(Country), data= NewData, na.action=na.omit)
summary(WithGovInteractionPlot3)
bgtest(WithGovInteractionPlot3) ##No autocorrelation 

WithGovInteractionPlot4<-lm(log(RenEnCon+1)~Lag3Women*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+GovLeftRight+as.factor(ElectionTerm)+ as.factor(Country), data= NewData, na.action=na.omit)
summary(WithGovInteractionPlot4)
bgtest(WithGovInteractionPlot4) ##autocorrelation 
coeftest(WithGovInteractionPlot4, vcov(WithGovInteractionPlot4, method="arellano"))

stargazer(WithGovInteractionPlot1, WithGovInteractionPlot2 , WithGovInteractionPlot3 , WithGovInteractionPlot4 , title = "All Democracies with Government Lean Control", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags", "log GDP per capita", 
                               "Vulnerability", "Resource Rents","Gov Left-Right Position", "Freedom House Score", "HDI"), notes.label="Significance levels", type = "html", out="Testing3.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))


interplot(m=WithGovInteractionPlot1, var1="WomenParl", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for Percent of Women in Parliaments")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=WithGovInteractionPlot2, var1="Lag1Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 1 Election term Lag of Percent of Women in Parliaments")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 1 lag, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=WithGovInteractionPlot3, var1="Lag2Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 2 Election term Lags of Percent of Women in Parliaments")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 2 lags, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=WithGovInteractionPlot4, var1="Lag3Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 3 Election term Lags of Percent of Women in Parliaments")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 3 lags, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

# Appendix Table 6:Interactions of Women in Parliament and Democracy Score, including Government Lean
WomenDemWithGov1<-lm(log(RenEnCon+1)~WomenParl*FreedomHouse+Vulnerability+ResourceRents+logGDP+HDI+GovLeftRight+as.factor(ElectionTerm)+ as.factor(Country), data= NewData, na.action=na.omit)
summary(WomenDemWithGov1)
bgtest(WomenDemWithGov1) ##Low p-value, autocorrelation 
coeftest(WomenDemWithGov1, vcov(WomenDemWithGov1, method="arellano"))

WomenDemWithGov2<-lm(log(RenEnCon+1)~Lag1Women*FreedomHouse+Vulnerability+ResourceRents+logGDP+HDI+GovLeftRight+as.factor(ElectionTerm)+ as.factor(Country), data= NewData, na.action=na.omit)
summary(WomenDemWithGov2)
bgtest(WomenDemWithGov2) ##No autocorrelation 

WomenDemWithGov3<-lm(log(RenEnCon+1)~Lag2Women*FreedomHouse+Vulnerability+ResourceRents+logGDP+HDI+GovLeftRight+as.factor(ElectionTerm)+ as.factor(Country), data= NewData, na.action=na.omit)
summary(WomenDemWithGov3)
bgtest(WomenDemWithGov3) ##No autocorrelation 

WomenDemWithGov4<-lm(log(RenEnCon+1)~Lag3Women*FreedomHouse+Vulnerability+ResourceRents+logGDP+HDI+GovLeftRight+as.factor(ElectionTerm)+ as.factor(Country), data= NewData, na.action=na.omit)
summary(WomenDemWithGov4)
bgtest(WomenDemWithGov4) ##autocorrelation 
coeftest(WomenDemWithGov4, vcov(WomenDemWithGov4, method="arellano"))

stargazer(WomenDemWithGov1, WomenDemWithGov2 , WomenDemWithGov3 , WomenDemWithGov4 , title = "Interactions of Women in Parliament and Democracy Score, including Government Lean", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags", "log GDP per capita", 
                               "Vulnerability", "Resource Rents","Gov Left-Right Position", "Freedom House Score", "HDI"), notes.label="Significance levels", type = "html", out="Testing3.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))



# Appendix Table 7: Models with Observations Removed before 3 Lags

LagDataSet<-subset(Data, ElectionTerm=="3"| ElectionTerm=="4"| ElectionTerm=="5"| ElectionTerm=="6"| ElectionTerm=="7"| ElectionTerm=="8"| ElectionTerm=="9"| ElectionTerm=="10"| ElectionTerm=="11")

LagModel1<-plm(log(RenEnCon+1)~WomenParl+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= LagDataSet, model = "within", effect = "twoways", na.action=na.omit)
summary(LagModel1)
pbgtest(LagModel1) ##Low p-value, autocorrelation 
coeftest(LagModel1, vcov(LagModel1, method="arellano"))

LagModel2<-plm(log(RenEnCon+1)~lag(WomenParl, 1)+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= LagDataSet, model = "within", effect = "twoways", na.action=na.omit)
summary(LagModel2)
pbgtest(LagModel2) ##Low p-value, autocorrelation 
coeftest(LagModel2, vcov(LagModel2, method="arellano"))

LagModel3<-plm(log(RenEnCon+1)~lag(WomenParl, 2)+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= LagDataSet, model = "within", effect = "twoways", na.action=na.omit)
summary(LagModel3)
pbgtest(LagModel3) ##Low p-value, autocorrelation 
coeftest(LagModel3, vcov(LagModel3, method="arellano"))

LagModel4<-plm(log(RenEnCon+1)~lag(WomenParl, 3)+log(GDPpercap)+Vulnerability+ResourceRents+FreedomHouse+HDI, data= LagDataSet, model = "within", effect = "twoways", na.action=na.omit)
summary(LagModel4)
pbgtest(LagModel4) ##Low p-value, autocorrelation 
coeftest(LagModel4, vcov(LagModel4, method="arellano"))
### Now, without a lag, the % women in parliament is significantly correlated with renewable energy consumption


stargazer(LagModel1,LagModel2, LagModel3, LagModel4, LagModel5, title = "All Democracies, Elections 1-3 Removed", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags","Women in Parliament, 4 lags","log GDP per capita", 
                               "Vulnerability", "Resource Rents", "Freedom House Score", "HDI"), notes.label="Significance levels", type = "html", out="NewModels2.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))

# Appendix Table 8: Models with Women in Parliament x GDP per capita interactions with observations removed before 3 lags
LagsInteraction1<-lm(log(RenEnCon+1)~WomenParl*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+as.factor(ElectionTerm)+ as.factor(Country), data= Data, na.action=na.omit)
summary(LagsInteraction1)

LagsInteraction2<-lm(log(RenEnCon+1)~Lag1Women*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+as.factor(ElectionTerm)+ as.factor(Country), data= Data, na.action=na.omit)
summary(LagsInteraction2)

LagsInteraction3<-lm(log(RenEnCon+1)~Lag2Women*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+as.factor(ElectionTerm)+ as.factor(Country), data= Data, na.action=na.omit)
summary(LagsInteraction3)

LagsInteraction4<-lm(log(RenEnCon+1)~Lag3Women*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+as.factor(ElectionTerm)+ as.factor(Country), data= Data, na.action=na.omit)
summary(LagsInteraction4)


# Appendix Table 9: Interaction of Women in Parliament and GDP on FITs

FIT1<-lm(FIT~WomenParl*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+as.factor(Country)+as.factor(ElectionTerm), data=EJPRData)
summary(FIT1)
interplot(m=FIT1, var1="WomenParl", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("LogGDP")+
  ylab("Estimated Coefficient for Percent of Women in Parliaments")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament on FIT")+
  theme(plot.title = element_text(face = "bold"))

FIT2<-lm(FIT~Lag1Women*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+as.factor(Country)+as.factor(ElectionTerm), data=EJPRData)
summary(FIT2)
interplot(m=FIT2, var1="Lag1Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("LogGDP")+
  ylab("Estimated Coefficient for Percent of Women in Parliaments, 1 Lag")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 1 Lag on FIT")+
  theme(plot.title = element_text(face = "bold"))

FIT3<-lm(FIT~Lag2Women*logGDP++Vulnerability+ResourceRents+FreedomHouse+HDI+as.factor(Country)+as.factor(ElectionTerm), data=EJPRData)
summary(FIT3)
interplot(m=FIT3, var1="Lag2Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("LogGDP")+
  ylab("Estimated Coefficient for Percent of Women in Parliaments, 2 Lags")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 2 Lags on FIT")+
  theme(plot.title = element_text(face = "bold"))

FIT4<-lm(FIT~Lag3Women*logGDP+Vulnerability+ResourceRents+FreedomHouse+HDI+as.factor(Country)+as.factor(ElectionTerm), data=EJPRData)
summary(FIT4)
interplot(m=FIT4, var1="Lag3Women", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("LogGDP")+
  ylab("Estimated Coefficient for Percent of Women in Parliaments, 3 Lags")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Parliament, 3 Lags on FIT")+
  theme(plot.title = element_text(face = "bold"))

stargazer(FIT1, FIT2, FIT3, FIT4, title = "Interaction of Women in Parliament and GDP on FITs", dep.var.labels ="FITs",
          covariate.labels = c("Women in Parliament","Women in Parliament, 1 lag","Women in Parliament, 2 lags", "Women in Parliament, 3 lags"), 
          notes.label="Significance levels", type = "html", out="FIT.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))

# Appendix Table 10: Interaction of Women in Cabinets and GDP per capita

InteractionCAB1<-plm(log(RenEnCon+1)~WomenCab*log(GDPpercap)+ WomenParl*log(GDPpercap)+ Vulnerability+ResourceRents+FreedomHouse+HDI, data= EJPRData, model = "within", effect = "twoways", na.action=na.omit)
summary(InteractionCAB1)
pbgtest(InteractionCAB1) ##Low p-value, autocorrelation 
coeftest(InteractionCAB1, vcov(InteractionCAB1, method="arellano"))

InteractionCAB2<-plm(log(RenEnCon+1)~lag(WomenCab, 1)*log(GDPpercap)+ WomenParl*log(GDPpercap)+ Vulnerability+ResourceRents+FreedomHouse+HDI, data= EJPRData, model = "within", effect = "twoways", na.action=na.omit)
summary(InteractionCAB2)
pbgtest(InteractionCAB2) ##Low p-value, autocorrelation 
coeftest(InteractionCAB2, vcov(Interaction2, method="arellano"))

InteractionCAB3<-plm(log(RenEnCon+1)~lag(WomenCab, 2)*log(GDPpercap)+ WomenParl*log(GDPpercap)+ Vulnerability+ResourceRents+FreedomHouse+HDI, data= EJPRData, model = "within", effect = "twoways", na.action=na.omit)
summary(InteractionCAB3)
pbgtest(InteractionCAB3) ## No autocorrelation 

InteractionCAB4<-plm(log(RenEnCon+1)~lag(WomenCab, 3)*log(GDPpercap)+ WomenParl*log(GDPpercap)+ Vulnerability+ResourceRents+FreedomHouse+HDI, data= EJPRData, model = "within", effect = "twoways", na.action=na.omit)
summary(InteractionCAB4)
pbgtest(InteractionCAB4) ##no autocorrelation 

stargazer(InteractionCAB1, InteractionCAB2, InteractionCAB3, InteractionCAB4, title = "Interaction of Women in Cabinets and GDP per capita", dep.var.labels ="Renewable Energy Consumption",
          covariate.labels = c("Women in Cabinets","Women in Cabinets, 1 lag","Women in Cabinets, 2 lags", "Women in Cabinets, 3 lags","log GDP per capita", "Women in Parliament x log GDP",
                               "Vulnerability", "Resource Rents", "Freedom House Score", "HDI", "Women in Cabinets x GDP per capita", "1 Lag Women in Cabinets x GDP per capita", 
                               "2 Lags Women in Cabinets x GDP per capita", "3 Lags Women in Cabinets x GDP per capita"), notes.label="Significance levels", type = "html", out="R&RCabinetModels.htm",
          star.char = c(".", "*", "**", "***"),
          star.cutoffs = c(.1, .05, .01, .001))

EJPRData$logGDP <- log(EJPRData$GDPpercap)
EJPRData <- slide(EJPRData, Var = 'WomenParl', NewVar = 'Lag1Women', slideBy = 1)
EJPRData <- slide(EJPRData, Var = 'WomenParl', NewVar = 'Lag2Women', slideBy = 2)
EJPRData <- slide(EJPRData, Var = 'WomenParl', NewVar = 'Lag3Women', slideBy = 3)
EJPRData <- slide(EJPRData, Var = 'WomenParl', NewVar = 'Lag4Women', slideBy = 4)

EJPRData <- slide(EJPRData, Var = 'WomenCab', NewVar = 'Lag1WomenCab', slideBy = 1)
EJPRData <- slide(EJPRData, Var = 'WomenCab', NewVar = 'Lag2WomenCab', slideBy = 2)
EJPRData <- slide(EJPRData, Var = 'WomenCab', NewVar = 'Lag3WomenCab', slideBy = 3)
EJPRData <- slide(EJPRData, Var = 'WomenCab', NewVar = 'Lag4WomenCab', slideBy = 4)

InteractionCABPlot1<-lm(log(RenEnCon+1)~WomenCab*logGDP + WomenParl*logGDP+ Vulnerability+ResourceRents+FreedomHouse+HDI + as.factor(ElectionTerm)+ as.factor(Country), data= EJPRData, na.action=na.omit)
summary(InteractionCABPlot1)

InteractionCABPlot2<-lm(log(RenEnCon+1)~Lag1WomenCab*logGDP + WomenParl*logGDP+ Vulnerability+ResourceRents+FreedomHouse+HDI + as.factor(ElectionTerm) + as.factor(Country), data= EJPRData, na.action=na.omit)
summary(InteractionCABPlot2)

InteractionCABPlot3<-lm(log(RenEnCon+1)~Lag2WomenCab*logGDP +WomenParl*logGDP+ Vulnerability+ResourceRents+FreedomHouse+HDI + as.factor(ElectionTerm) + as.factor(Country), data= EJPRData, na.action=na.omit)
summary(InteractionCABPlot3)

InteractionCABPlot4<-lm(log(RenEnCon+1)~Lag3WomenCab*logGDP +WomenParl*logGDP+ Vulnerability+ResourceRents+FreedomHouse+HDI + as.factor(ElectionTerm) + as.factor(Country), data= EJPRData,na.action=na.omit)
summary(InteractionCABPlot4)

interplot(m=InteractionCABPlot1, var1="WomenCab", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for Percent of Women in Cabinets")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Cabinets on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=InteractionCABPlot2, var1="Lag1WomenCab", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 1 Election term Lag of Percent of Women in Cabinets")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Cabinets, 1 lag, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=InteractionCABPlot3, var1="Lag2WomenCab", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 2 Election term Lags of Percent of Women in Cabinets")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Cabinets, 2 lags, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

interplot(m=InteractionCABPlot4, var1="Lag3WomenCab", var2="logGDP", hist = TRUE)+
  geom_hline(yintercept = 0, linetype="dashed")+
  xlab("log GDP per capita")+
  ylab("Estimated Coefficient for 3 Election term Lags of Percent of Women in Cabinets")+
  theme_bw()+
  ggtitle("Estimated Coefficient of Women in Cabinets, 3 lags, on Renewable Energy Consumption by log of GDP per capita")+
  theme(plot.title = element_text(face = "bold"))

