*** This do-file corresponds to the dataset "Goldberg_Sciarini_data_EJPR.dta" 
*** Note: there is also a R syntax for the individual-level analysis
*** Article: "What drives turnout in direct democratic votes? A joint analysis of individual, referendum and community factors"
*** Authors: A.C. Goldberg / P. Sciarini
*** Journal: European Journal of Political Research
*** Date: 27 July 2021

use "... Goldberg_Sciarini_data_EJPR.dta", clear

**** Table 3 *******

* Test for autocorrelation (present)
tsset Community_code qdate, quarterly

xtserial turnout intensity_absolutge_stand lager_avg_stand ///
	fr_importance_max_stand intpolitics social institutions energy economy culture ///
	complex_min_stand nrballots_stand ///
	medinc_stand unempl_stand density_stand ndrdsec_stand catholic_stand
	
* Test for heteroskedasticity (not present)
xtgls turnout intensity_absolutge_stand lager_avg_stand ///
	fr_importance_max_stand intpolitics social institutions energy economy culture ///
	complex_min_stand nrballots_stand ///
	medinc_stand unempl_stand density_stand ndrdsec_stand catholic_stand, igls panels(heteroskedastic)

estimates store hetero	

xtgls turnout intensity_absolutge_stand lager_avg_stand ///
	fr_importance_max_stand intpolitics social institutions energy economy culture ///
	complex_min_stand nrballots_stand ///
	medinc_stand unempl_stand density_stand ndrdsec_stand catholic_stand, igls

local df = e(N_g) - 1
lrtest hetero . , df(`df')



** Model with panel-corrected SEs using xtgls 
xtset Community_code qdate

xtgls turnout intensity_absolutge_stand lager_avg_stand ///
	fr_importance_max_stand intpolitics social institutions energy economy culture ///
	complex_min_stand nrballots_stand ///
	medinc_stand unempl_stand density_stand ndrdsec_stand catholic_stand, panels(iid) corr(ar1) force


	
	
** Test for multicollinearity by calculating the VIF factor
reg turnout intensity_absolutge_stand lager_avg_stand ///
	fr_importance_max_stand intpolitics social institutions energy economy culture ///
	complex_min_stand nrballots_stand ///
	medinc_stand unempl_stand density_stand ndrdsec_stand catholic_stand

estat vif
