### Article: "What drives turnout in direct democratic votes? A joint analysis of individual, referendum and community factors"
### Authors: A.C. Goldberg / P. Sciarini
### Journal: European Journal of Political Research
### Date: 27 July 2021


library(foreign)
library(readstata13)
library(lme4)
library(insight)
library(ggeffects)


## Data (see respective data statement) ##

setwd("D:/Desktop")
data <- read.dta13("context_vote_community_150k.dta",convert.factors=F)



## TABLE 4 ##



# EMPTY MODEL FOR ICC

M1 <- glmer(vote ~ 1 + (1 | scrutin1) + (1 | DOMICOM), 
            data=data , family = binomial(link = "logit"),  control=glmerControl(optimizer="nloptwrap"))

sum(get_variance_random(M1)) / (sum(get_variance_random(M1)) + get_variance_residual(M1))
sum(get_variance_intercept(M1)[1]) / (sum(get_variance_random(M1)) + get_variance_residual(M1))
sum(get_variance_intercept(M1)[2]) / (sum(get_variance_random(M1)) + get_variance_residual(M1))




#MODEL 1
M2a <- glmer(vote ~ 
              agec + I(agec*agec) 
            + cumul_per + woman + married + divorced_widow 
            + less10years + more10years + gvacit + (1 | scrutin1) + (1 | DOMICOM), 
            data=data , family = binomial(link = "logit"),  control=glmerControl(optimizer="nloptwrap"))

#MODEL 2
M2b <- glmer(vote ~  
               intensity_absolutge_stand + lager_avg_stand + fr_importance_max_stand 
             + intpolitics + social + institutions + energy + economy + culture
             + complex_min_stand + nrballots_stand
             + medinc_stand + unempl_stand + density_stand  + ndrdsec_stand + 
             + catholic_stand
             + (1 | scrutin1) + (1 | DOMICOM), 
             data=data , family = binomial(link = "logit"),  control=glmerControl(optimizer="nloptwrap"))

#MODEL 3
M2c <- glmer(vote ~  
               intensity_absolutge_stand + lager_avg_stand + fr_importance_max_stand 
             + intpolitics + social + institutions + energy + economy + culture
             + complex_min_stand + nrballots_stand
             + medinc_stand + unempl_stand + density_stand  + ndrdsec_stand + 
             + catholic_stand + communityvote_simple_stand
             + (1 | scrutin1) + (1 | DOMICOM), 
             data=data , family = binomial(link = "logit"),  control=glmerControl(optimizer="nloptwrap"))

#MODEL 4
M2d <- glmer(vote ~  
               intensity_absolutge_stand + lager_avg_stand + fr_importance_max_stand 
             + intpolitics + social + institutions + energy + economy + culture
             + complex_min_stand + nrballots_stand
             + medinc_stand + unempl_stand + density_stand  + ndrdsec_stand + 
             + catholic_stand
             + agec + I(agec*agec) 
             + cumul_per + woman + married + divorced_widow  
             + less10years + more10years + gvacit + (1 | scrutin1) + (1 | DOMICOM), 
             data=data , family = binomial(link = "logit"),  control=glmerControl(optimizer="nloptwrap"))

#MODEL 5
M2e <- glmer(vote ~  
               intensity_absolutge_stand + lager_avg_stand + fr_importance_max_stand 
             + intpolitics + social + institutions + energy + economy + culture
             + complex_min_stand + nrballots_stand
             + medinc_stand + unempl_stand + density_stand  + ndrdsec_stand + 
             + catholic_stand + communityvote_simple_stand
             + agec + I(agec*agec) 
             + cumul_per + woman + married + divorced_widow  
             + less10years + more10years + gvacit + (1 | scrutin1) + (1 | DOMICOM), 
             data=data , family = binomial(link = "logit"),  control=glmerControl(optimizer="nloptwrap"))


# Predicted probabilities for sig. effects in Model 5 (-1SD +1SD)
ggpredict(M2e, "agec [-19,17]")
ggpredict(M2e, "divorced_widow [0,1]")
ggpredict(M2e, "cumul_per [0.127,0.823]")
ggpredict(M2e, "fr_importance_max_stand [-1,1]")
ggpredict(M2e, "intpolitics [0,1]")
ggpredict(M2e, "energy [0,1]")
ggpredict(M2e, "complex_min_stand [-1,1]")
ggpredict(M2e, "nrballots_stand [-1,1]")
ggpredict(M2e, "medinc_stand [-2.00,-0.15]")
ggpredict(M2e, "communityvote_simple_stand [-1,1]")