#R code for paper "Oral Interventions in the UN General Assembly: Accounting
#for the Variance in EU Member-States' Engagement"#
# Spyros Blavoukos and Ioannis Galariotis #
# Version: 28 June 2024 #
# For questions about the code and the results: jgalariotis@gmail.com #
# Load required packages #
library(tidyverse)
library(ggplot2)
library(ggpmisc)
library(lme4)
library(nlme)

#read dataset#
df <- total_data

# names of the variables in Table 2 and the R code #
# GDP = gdp #
# Population = pop #
# Presidency = presidency #
# UNSC membership = UNSC_membership #
# UNSC candidate = UNSC_candidate #

# create Graph 1 #
df_country_interventions <- df %>% 
  group_by(country) %>% 
  summarise(interventions = sum(interventions))


ggplot(df_country_interventions, aes(x = country, y = interventions)) +
  geom_bar(fill = "#0073C2FF", stat = "identity") +
  geom_text(aes(label = interventions), vjust = 0.1) + 
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1))
theme_pubclean()marise(interventions = n())
df_country_interventions

### models ###
#### 3-levels longitudinal multilevel random intercept models #####
#empty model (Base model in Table 2) #
mod_lme_empty <- lme(fixed = interventions ~ 1, random = ~ 1|com/country, 
                     weights = varPower(form = ~ year1), 
                     correlation = corARMA(c(0.1, 0.9), form = ~ 1 | com/country, p=0, q=2),
                     data=df)
summary(mod_lme_empty)

#run also with lmer to find the variance components#
mod_lmer_empty <- lmer(interventions ~ 1 + (1|com/country), 
                     data=df)
summary(mod_lmer_empty)

#add GDP and population (Interim model 1 in Table 2)#
mod_lme_gdp_pop <- lme(fixed = interventions ~ gdp + pop, random = ~ 1|com/country, 
                       weights = varPower(form = ~ year1), 
                       correlation = corARMA(c(0.1, 0.9), form = ~ 1 | com/country, p=0, q=2),
                       data=df)
summary(mod_lme_gdp_pop)
#run also with lmer to find the variance components#
mod_lmer_gdp_pop <- lmer(interventions ~ gdp + pop + (1|com/country), 
                      data=df)
summary(mod_lmer_gdp_pop)


#add Presidency (Interim model 2 in Table 2)#
mod_lme_gdp_pop_presidency <- lme(fixed = interventions ~ gdp + pop + presidency, random = ~ 1|com/country, 
                   weights = varPower(form = ~ year1), 
                   correlation = corARMA(c(0.1, 0.9), form = ~ 1 | com/country, p=0, q=2),
                   data=df)
summary(mod_lme_gdp_pop_presidency)

#run also with lmer to find the variance components#
mod_lmer_dgp_pop_presidency <- lmer(interventions ~ gdp + pop + presidency + (1|com/country), 
                           data=df)
summary(mod_lmer_dgp_pop_presidency)

#add also UNSC_membership and UNSC_candidate...now the model is full (Final model in Table 2)#
mod_lme_all <- lme(fixed = interventions ~ gdp + pop + + presidency + UNSC_membership +
                     UNSC_candidate, random = ~ 1|com/country, 
                   weights = varPower(form = ~ year1), 
                   correlation = corARMA(c(0.1, 0.9), form = ~ 1 | com/country, p=0, q=2),
                   data=df)
summary(mod_lme_all)

#run also with lmer to find the variance components#
mod_lmer_all <- lmer(interventions ~ gdp + pop + + presidency + UNSC_membership +
                       UNSC_candidate + (1|com/country), 
                    data=df)
summary(mod_lmer_all)
### here the code ends ###