

* THIS FILE USES TWO DATASETS TO REPLICATE TABLE 3. TABLE 3, COLUMN A, IS BASED  
* ON THE VULNERABLE NEIGHBORHOOD SAMPLE AND COLUMN B ON THE NATIONAL SAMPLE.
* TABLE 5 IS ONLY BASED ON THE VULNERABLE NEIGHBORHOOD SAMPLE.


*** USE DATASET WITH VULNERABLE NEIGHBORHOOD SAMPLE ***

clear all
/* Adjust the path */ use "data_table_3_column_a_table_5.dta"



*** TABLE 3, COLUMN A VULNERABLE NEIGHBORHOOD ***


ta vikt1t w, col
ta vikt2t w, col
ta vikt3t w, col
ta vikt4t w, col
ta vikt5t w, col
ta vikt6t w, col
ta vikt7t w, col
ta vikt8t w, col
ta vikt9t w, col
ta vikt10t w, col
ta vikt11t w, col
ta vikt12t w, col
ta vikt13t w, col
ta vikt14t w, col


/* For the t-test below */ 
sum vikt1t-vikt14t

/*
    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
      vikt1t |      1,141    4.728309    .6842691          1          5
      vikt2t |      1,182    4.642978    .6967547          1          5
      vikt3t |        479    4.177453    1.028787          1          5
      vikt4t |      1,143    3.931759    1.156977          1          5
      vikt5t |        472    3.963983    1.020374          1          5
-------------+---------------------------------------------------------
      vikt6t |      1,147    4.697472    .7015457          1          5
      vikt7t |      1,142    4.438704    .8936475          1          5
      vikt8t |      1,190    4.318487    .9567138          1          5
      vikt9t |      1,147    4.733217    .6070876          1          5
     vikt10t |      1,140    4.490351    .7799585          1          5
-------------+---------------------------------------------------------
     vikt11t |      1,138    4.741652    .6578433          1          5
     vikt12t |        468    4.311966    .9120335          1          5
     vikt13t |        465    4.133333    .9351071          1          5
     vikt14t |        657    4.229833    1.049314          1          5


*/
	 
	 
* RESHAPE TO WIDE *

reshape wide vikt1t vikt2t vikt3t vikt4t vikt5t vikt6t vikt7t vikt8t vikt9t vikt10t vikt11t vikt12t vikt13t vikt14t, i(id) j(w)


* NORMALIZE DV:S TO RANGE FROM 0 TO 1

sum vikt1t1
replace vikt1t1 = (vikt1t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt2t1
replace vikt2t1 = (vikt2t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt3t1
replace vikt3t1 = (vikt3t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt4t1
replace vikt4t1 = (vikt4t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt5t1
replace vikt5t1 = (vikt5t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt6t1
replace vikt6t1 = (vikt6t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt7t1
replace vikt7t1 = (vikt7t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt8t1
replace vikt8t1 = (vikt8t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt9t1
replace vikt9t1 = (vikt9t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt10t1
replace vikt10t1 = (vikt10t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt11t1
replace vikt11t1 = (vikt11t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt12t1
replace vikt12t1 = (vikt12t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt13t1
replace vikt13t1 = (vikt13t1-`r(min)') / (`r(max)'-`r(min)')
sum vikt14t2
replace vikt14t2 = (vikt14t2-`r(min)') / (`r(max)'-`r(min)')



*** TABLE 5 BIVARIATE REGRESSIONS ***

reg vikt1t1 nonethnic_swe, robust 
reg vikt2t1 nonethnic_swe, robust
reg vikt3t1 nonethnic_swe, robust
reg vikt4t1 nonethnic_swe, robust
/* effect sizes estimate with the following command */
esize twosample vikt4t1, by(nonethnic_swe) all
reg vikt5t1 nonethnic_swe, robust
reg vikt6t1 nonethnic_swe, robust
reg vikt7t1 nonethnic_swe, robust
reg vikt8t1 nonethnic_swe, robust
reg vikt9t1 nonethnic_swe, robust
reg vikt10t1 nonethnic_swe, robust
reg vikt11t1 nonethnic_swe, robust
reg vikt12t1 nonethnic_swe, robust
reg vikt13t1 nonethnic_swe, robust
reg vikt14t2 nonethnic_swe, robust

reg vikt1t1 somali, robust
reg vikt2t1 somali, robust
reg vikt3t1 somali, robust
reg vikt4t1 somali, robust
reg vikt5t1 somali, robust
reg vikt6t1 somali, robust
reg vikt7t1 somali, robust
reg vikt8t1 somali, robust
reg vikt9t1 somali, robust
reg vikt10t1 somali, robust
reg vikt11t1 somali, robust
reg vikt12t1 somali, robust
reg vikt13t1 somali, robust
reg vikt14t2 somali, robust
 
reg vikt1t1 muslim, robust
reg vikt2t1 muslim, robust
reg vikt3t1 muslim, robust
reg vikt4t1 muslim, robust
reg vikt5t1 muslim, robust
reg vikt6t1 muslim, robust
reg vikt7t1 muslim, robust
reg vikt8t1 muslim, robust
reg vikt9t1 muslim, robust
reg vikt10t1 muslim, robust
reg vikt11t1 muslim, robust
reg vikt12t1 muslim, robust
reg vikt13t1 muslim, robust
reg vikt14t2 muslim, robust

reg vikt1t1 female, robust
reg vikt2t1 female, robust
reg vikt3t1 female, robust
reg vikt4t1 female, robust
reg vikt5t1 female, robust
reg vikt6t1 female, robust
reg vikt7t1 female, robust
reg vikt8t1 female, robust
reg vikt9t1 female, robust
reg vikt10t1 female, robust
reg vikt11t1 female, robust
reg vikt12t1 female, robust
reg vikt13t1 female, robust
reg vikt14t2 female, robust

reg vikt1t1 bergsjon, robust
reg vikt2t1 bergsjon, robust
reg vikt3t1 bergsjon, robust
reg vikt4t1 bergsjon, robust
reg vikt5t1 bergsjon, robust
reg vikt6t1 bergsjon, robust
reg vikt7t1 bergsjon, robust
reg vikt8t1 bergsjon, robust
reg vikt9t1 bergsjon, robust
reg vikt10t1 bergsjon, robust
reg vikt11t1 bergsjon, robust
reg vikt12t1 bergsjon, robust
reg vikt13t1 bergsjon, robust
reg vikt14t2 bergsjon, robust


* TABLE S9 MULTIPLE REGRESSION ANALYSIS

reg vikt1t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt2t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt3t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt4t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt5t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt6t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt7t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt8t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt9t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt10t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt11t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt12t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt13t1 nonethnic_swe somali muslim female bergsjon, robust
reg vikt14t2 nonethnic_swe somali muslim female bergsjon, robust



*** USE DATASET WITH NATIONAL SAMPLE ***
 
clear all
/* Adjust the path */ use "data_table_3_column_b.dta"


ta vikt_1
ta vikt_2
ta vikt_3
ta vikt_6
ta vikt_7
ta vikt_8
ta vikt_9
ta vikt_10
ta vikt_11
ta vikt_12
ta vikt_13
ta vikt_14

sum vikt_1-vikt_14

/*

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
      vikt_1 |      1,015    4.341872    .9433513          1          5
      vikt_2 |      1,000        3.99    .9720313          1          5
      vikt_3 |      1,021    3.687561    1.119932          1          5
      vikt_6 |      1,006    4.208748    .9815021          1          5
      vikt_7 |      1,007    4.059583    1.119334          1          5
-------------+---------------------------------------------------------
      vikt_8 |      1,004    3.065737    1.285575          1          5
      vikt_9 |      1,023    4.086999    .8743223          1          5
     vikt_10 |        997    4.382146    .7613942          1          5
     vikt_11 |        992    4.288306    .8661969          1          5
     vikt_12 |      1,003    3.059821    1.086301          1          5
-------------+---------------------------------------------------------
     vikt_13 |        987    3.480243    1.024232          1          5
     vikt_14 |        953    3.306401    1.360661          1          5


	 

*/

*** TWO-SAMPLE T-TEST, COMPARISON ***

/* 1 */ ttesti  1015    4.341872     .9433513  1141    4.728309     .6842691 
/* 2 */ ttesti  1000    3.99         .9720313  1182    4.642978     .6967547 
/* 3 */ ttesti  1021    3.687561    1.119932   479     4.177453    1.028787
/* 6 */ ttesti  1006    4.208748     .9815021  1147    4.697472     .7015457
/* 7 */ ttesti  1007    4.059583    1.119334   1142    4.438704     .8936475
/* 8 */ ttesti  1004    3.065737    1.285575   1190    4.318487     .9567138 
/* 9 */ ttesti  1023    4.086999     .8743223  1147    4.733217     .6070876 
/* 10 */ ttesti 997     4.382146     .7613942  1140    4.490351     .7799585
/* 11 */ ttesti 992     4.288306     .8661969  1138    4.741652     .6578433
/* 12 */ ttesti 1003    3.059821    1.086301   468     4.311966     .9120335 
/* 13 */ ttesti 987     3.480243    1.024232   465     4.133333     .9351071
/* 14 */ ttesti 953     3.306401    1.360661   657     4.229833    1.049314

