library(data.table)
library(ggplot2)
rm(list=ls())


#data sources:
#https://www.uni-mannheim.de/media/Einrichtungen/gip/Response_Rates/German_Internet_Panel_Response_Rates.pdf
#https://www.uni-mannheim.de/en/gip/corona-study/methodology/#c192450

dat <- fread("response_rates.csv")
mcs <- dat[Week<20]

#https://www.uni-mannheim.de/gip/corona-studie/methodik/#c192445
aarb <- fread("AARBs.csv")

p2 <- ggplot(data=mcs, aes(y=Total*100, x=Week))
p2 <- p2 + geom_line()
p2 <- p2 + geom_line(linetype="dashed", data=aarb)
p2 <- p2 + theme_bw()
p2 <- p2 + scale_y_continuous("Response Rate (%)\nAARB (%)", limits=c(0, 100),
                              breaks=c(0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100))
p2 <- p2 + scale_x_continuous("MCS Week", breaks=1:16)
p2


