###########################################################################################################
# Function assign a value that appears in a single wave of a panel to all observation for that individual #
###########################################################################################################


################################
# Last edited:                 #
# 26 July 2024 by Roni Lehrer  #
################################

panel.expand <- function(x) {
  un <- unique(x)
  if (all(is.na(un))) {
    return(rep(NA, length(x)))
  } else {
    return(rep(sort(un), length(x)))
  }
}
