
**********************************************************************
** title: 		The ideological profile of the technocratic citizen **
** authors:		bertsou, caramani, koedam							**
** journal:		EJPR	 											**
** year:		2024												**
** software:	Stata 17											**	
**********************************************************************


// Data
use "~/data/ideologyEU7USAUS.dta"


// Manuscript Table 1
tab  country class, row


// Manuscript Figure 1
twoway (kdensity LR if class !=3, bwidth(.45) k(gaussian) recast(area) color(gs8%30)) (kdensity LR if class==3, bwidth(.45) k(gaussian) recast(area) color(blue%40)), graphregion(color(white)) scheme(s2mono) xtitle("General Left-Right") ytitle("Density") ylab(0(.1).3) legend(order(2 1) label(1 "Other") label(2 "Technocrat") rows(1))

twoway (kdensity LR if class==5, k(gaussian) recast(area) color(gs3%50)) (kdensity LR if class==4, k(gaussian) recast(area) color(gs8%30)) (kdensity LR if class==3, k(gaussian) recast(area) color(blue%40)), graphregion(color(white)) scheme(s2mono) xtitle("General Left-Right") ytitle("Density") ylab(0(.1).3) legend(order(3 2 1) label(1 "Populist") label(2 "Party-Dem.") label(3 "Technocrat") rows(1))


// Manuscript Figure 2
* Party-Dem (0) vs Technocratic (1)
mlogit techvspart LR LR2 polint natpoltrust educat demage female i.country
predict modB, p
graph twoway (qfitci modB LR), title("Technocratic (1) vs Party-Democratic (0)", size(medium)) xtitle("Left-Right Ideology") ylabel(0(.2)1) graphregion(color(white)) name(LRPartTech, replace)

* Populist (0) vs Technocratic (1)
mlogit techvspop LR LR2 polint natpoltrust educat demage female i.country
predict modA, p
graph twoway (qfitci modA LR) , title("Technocratic (1) vs Populist (0)", size(medium)) xtitle("Left-Right Ideology") ylabel(0(.2)1) graphregion(color(white)) name(LRPopTech, replace)

graph combine LRPartTech LRPopTech, ycommon xcommon graphregion(color(white))


// Manuscript Figure 3
mlogit class c.LR##c.LR polint natpoltrust educat demage female i.country, baseoutcome(3) 

margins, at(LR =(1(1) 10)) predict(outcome(3)) vsquish
marginsplot, title("") xtitle("Left-Right Ideology") ytitle("Technocratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(2)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Technocratic2, replace)

margins, at(LR =(1(1) 10)) predict(outcome(4)) vsquish
marginsplot, title("") xtitle("Left-Right Ideology") ytitle("Party-Democratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(2)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(PartyDemocratic2, replace)

margins, at(LR =(1(1) 10)) predict(outcome(5)) vsquish
marginsplot, title("") xtitle("Left-Right Ideology") ytitle("Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(2)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Populist2, replace)

graph combine Technocratic2 PartyDemocratic2 Populist2, ysize(1.7) xsize(4) row(1) graphregion(color(white))


// Manuscript Figure 4
* Econ. dimension
collapse (mean) econid_rs
gen class = 99
sa total, replace
use "~/data/ideologyEU7USAUS.dta"
collapse (mean) econid_rs, by(class)
append using total
lab def class 99 "Overall", modify
drop if class != 3 &  class !=4 &  class !=5 
gr bar econid_rs, over(class, label(angle(45) labsize(small))) blabel(bar, format(%4.2g))
gen frommean = econid_rs - 3.26
graph hbar frommean , over(class) yline(0) blabel(bar, format(%4.2g)) graphregion(color(white)) ylabel(-1(.5)1) scheme(s2mono)

* Cult. dimension
collapse (mean) cultid_rs
gen class = 99
sa total, replace
use "~/data/ideologyEU7USAUS.dta"
collapse (mean) cultid_rs, by(class)
append using total
lab def class 99 "Overall", modify
drop if class != 3 &  class !=4 &  class !=5 
gr bar cultid_rs, over(class, label(angle(45) labsize(small))) blabel(bar, format(%4.2g))
generate frommean = cultid_rs - 4.883102
graph hbar frommean , over(class) yline(0) blabel(bar, format(%4.2g)) graphregion(color(white)) ylabel(-1(.5)1) scheme(s2mono)


// Manuscript Figure 5
twoway (kdensity econid_rs if class !=3, bwidth(.45) k(gaussian) recast(area) color(gs8%30)) (kdensity econid_rs if class==3, bwidth(.45) k(gaussian) recast(area) color(blue%40)), graphregion(color(white)) scheme(s2mono) xtitle("Economic Dimension") ytitle("Density") ylab(0(.1).3) legend(order(2 1) label(1 "Other") label(2 "Technocrat") rows(1))

twoway (kdensity cultid_rs if class !=3, bwidth(.45) k(gaussian) recast(area) color(gs8%30)) (kdensity cultid_rs if class==3, bwidth(.45) k(gaussian) recast(area) color(blue%40)), graphregion(color(white)) scheme(s2mono) xtitle("Cultural Dimension") ytitle("Density") ylab(0(.1).3) legend(order(2 1) label(1 "Other") label(2 "Technocrat") rows(1)) 


// Manuscript Figure 6
hexplot cultid_rs econid_rs if class==3, colors(tab Blue-Teal) xbins(11) ybins(11) ylabel(, nogrid) legend(off) xtitle("Economic") ytitle("Cultural") title("Technocrat") graphregion(color(white)) aspect(.8) addplot(pci -1 5 11 5, lcolor(gray) || pci 5 -1 5 11, lcolor(gray))

hexplot cultid_rs econid_rs if class==4, colors(tab Blue-Teal) xbins(11) ybins(11) ylabel(, nogrid) legend(off) xtitle("Economic") ytitle("Cultural") title("Party-democratic") graphregion(color(white)) aspect(.8) addplot(pci -1 5 11 5, lcolor(gray) || pci 5 -1 5 11, lcolor(gray))

hexplot cultid_rs econid_rs if class==5, colors(tab Blue-Teal) xbins(11) ybins(11) ylabel(, nogrid) legend(off) xtitle("Economic") ytitle("Cultural") title("Populist") graphregion(color(white)) aspect(.8) addplot(pci -1 5 11 5, lcolor(gray) || pci 5 -1 5 11, lcolor(gray))


// Manuscript Figure 7
mlogit class polint natpoltrust c.econid_rs##c.econid_rs educat demage female i.country, baseoutcome(3) 

margins, at(econid_rs =(0(1) 10)) predict(outcome(3)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Technocratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(0(2)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Technocraticec, replace)

margins, at(econid_rs =(0(1) 10)) predict(outcome(4)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Party-Democratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(0(2)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(PartyDemocraticec, replace)

margins, at(econid_rs =(0(1) 10)) predict(outcome(5)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(0(2)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Populistec, replace)

graph combine Technocraticec PartyDemocraticec Populistec,  ysize(1.7) xsize(4) row(1) graphregion(color(white))


// Manuscript Figure 8
mlogit class polint natpoltrust c.cultid_rs##c.cultid_rs educat demage female i.country, baseoutcome(3)

margins, at(cultid_rs =(0(1) 10)) predict(outcome(3)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Technocratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(0(2)10) yscale(range(0 .52)) ylab(0(.1).5) scheme(s1mono) name(Technocraticcult, replace)

margins, at(cultid_rs =(0(1) 10)) predict(outcome(4)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Party-Democratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(0(2)10) yscale(range(0 .52)) ylab(0(.1).5) scheme(s1mono) name(PartyDemocraticcult, replace)

margins, at(cultid_rs =(0(1) 10)) predict(outcome(5)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(0(2)10) yscale(range(0 .52)) ylab(0(.1).5) scheme(s1mono) name(Populistcult, replace)

graph combine Technocraticcult PartyDemocraticcult Populistcult, ysize(1.7) xsize(4) row(1) graphregion(color(white))



****************
*** APPENDIX ***
****************

// Appendix Table A2
factor EXP1 EXP2 EXP3 EXP4 AP1 AP2 AP3 AP4 EL1 EL2 EL3 EL4 POP1 POP2 POP3 POP4 POP5, pcf blanks(.3)
rotate, promax blanks(.3)


// Appendix Table B1 & Figure B1
* See "EJPR_technocraticvoter.R"


// Appendix Table B2
tab class


// Appendix Table B3
tab  country class, row


// Appendix Table B4
mean expertise antipolitics elitism popscale, over (class)


// Appendix Figure B2
graph bar (mean) expertise antipolitics elitism popscale if class!= 1 & class != 2 & class != 6 & class != 7, over(class) blabel(bar, format(%4.2g)) by(country)


// Appendix Table B5
factor Rid1 Rid4 id5 id8  id10 id11    , pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==1, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==2, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==3, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==4, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==5, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==6, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==9, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==10, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)
factor Rid1 Rid4 id5 id8  id10 id11     if country==11, pcf  blanks(.3)
rotate, promax(4) oblique blanks(.2)


// Appendix Table C1
tabstat LR econid_rs cultid_rs, statistics(mean sd) by(class)


// Appendix Table C2
mlogit class LR LR2 polint natpoltrust educat demage female, baseoutcome(4) rrr vce(cluster country) /*model 1*/
mlogit class LR LR2 polint natpoltrust educat demage female, baseoutcome(5) rrr vce(cluster country) /*model 2*/


// Appendix Table C2.1
mlogit class LR LR2 polint natpoltrust educat demage female i.country, baseoutcome(4) rrr /*model 1*/
mlogit class LR LR2 polint natpoltrust educat demage female i.country, baseoutcome(5) rrr /*model 2*/
jackknife, cluster(country): mlogit class LR LR2 polint natpoltrust educat demage female, baseoutcome(4) rrr /*model 1jk*/
jackknife, cluster(country): mlogit class LR LR2 polint natpoltrust educat demage female, baseoutcome(5) rrr /*model 2jk*/


// Appendix Table C3 (vs. populist) & C4 (vs. party-democratic)
mlogit class econid_rs polint natpoltrust educat demage female, baseoutcome(3) rrr vce(cluster country) 
mlogit class c.econid_rs##c.econid_rs polint natpoltrust educat demage female, baseoutcome(3) rrr vce(cluster country) /*model 2*/
mlogit class cultid_rs polint natpoltrust educat demage female, baseoutcome(3) rrr vce(cluster country) /*model 3*/
mlogit class c.cultid_rs##c.cultid_rs polint natpoltrust educat demage female, baseoutcome(3) rrr vce(cluster country) /*model 4*/
mlogit class econid_rs cultid_rs polint natpoltrus educat demage female, baseoutcome(3) rrr vce(cluster country) /*model 5*/
mlogit class c.econid_rs##c.econid_rs c.cultid_rs##c.cultid_rs polint natpoltrust educat demage female, baseoutcome(3) rrr vce(cluster country) /*model 6*/


// Appendix Figure C1
mlogit class polint natpoltrust c.econid_rs##c.econid_rs educat demage female, baseoutcome(3) vce(cluster country)

margins, at(econid_rs =(0(1)10)) predict(outcome(3)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Technocratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Technocraticec, replace)

margins, at(econid_rs =(0(1)10)) predict(outcome(4)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Party-Democratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(PartyDemocraticec, replace)

margins, at(econid_rs =(0(1)10)) predict(outcome(5)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Populistec, replace)

margins, at(econid_rs =(0(1)10)) predict(outcome(1)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Trackers") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Trackersec, replace)

margins, at(econid_rs =(0(1)10)) predict(outcome(2)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Mod. Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(ModPopulistec, replace) 

margins, at(econid_rs =(0(1)10)) predict(outcome(7)) vsquish
marginsplot,title("") xtitle("Economic Ideology") ytitle("ExtremePD") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(ExtrPDec, replace)

graph combine Technocraticec PartyDemocraticec Populistec ModPopulistec Trackersec ExtrPDec , ysize(1.7) xsize(4) row(2) graphregion(color(white))


// Appendix Figure C1.2
mlogit class polint natpoltrust c.Rid1##c.Rid1 educat demage female, baseoutcome(3) vce(cluster country)

margins, at(Rid1 =(1(1)7)) predict(outcome(3)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Technocratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)7) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Technocraticec, replace)

margins, at(Rid1 =(1(1)7)) predict(outcome(4)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Party-Democratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)7) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(PartyDemocraticec, replace)

margins, at(Rid1 =(1(1)7)) predict(outcome(5)) vsquish
marginsplot, title("") xtitle("Economic Ideology") ytitle("Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)7) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Populistec, replace)

graph combine Technocraticec PartyDemocraticec Populistec,  ysize(1.7) xsize(4) row(1) graphregion(color(white))


// Appendix Figure C2
mlogit class polint natpoltrust c.cultid_rs##c.cultid_rs educat demage female, baseoutcome(3) vce(cluster country)

margins, at(cultid_rs =(0(1)10)) predict(outcome(3)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Technocratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Technocraticcult, replace)

margins, at(cultid_rs =(0(1)10)) predict(outcome(4)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Party-Democratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(PartyDemocraticcult, replace)

margins, at(cultid_rs =(0(1)10)) predict(outcome(5)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Populistcult, replace)

margins, at(cultid_rs =(0(1)10)) predict(outcome(1)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Trackers") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Trackerscult, replace)

margins, at(cultid_rs =(0(1)10)) predict(outcome(2)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Mod. Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(ModPopulistcult, replace) 

margins, at(cultid_rs =(0(1)10)) predict(outcome(7)) vsquish
marginsplot,title("") xtitle("Cultural Ideology") ytitle("ExtremePD") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)10) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(ExtrPDcult, replace)

graph combine Technocraticcult PartyDemocraticcult Populistcult ModPopulistcult Trackerscult ExtrPDcult, ysize(1.7) xsize(4) row(2) graphregion(color(white))


// Appendix Figure C2.2
mlogit class polint natpoltrust c.id10##c.id10 educat demage female  , baseoutcome(3) vce(cluster country)

margins, at(id10 =(1(1)7)) predict(outcome(3)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Technocratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)7) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Technocraticcult, replace)

margins, at(id10 =(1(1)7)) predict(outcome(4)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Party-Democratic") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)7) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(PartyDemocraticcult, replace)

margins, at(id10 =(1(1)7)) predict(outcome(5)) vsquish
marginsplot, title("") xtitle("Cultural Ideology") ytitle("Populist") recast(line) plotopts(lcolor(black) lwidth(.2)) graphregion(color(white)) ciopts(color(gs14)) recastci(rarea) xlab(1(1)7) yscale(range(0 .5)) ylab(0(.1).5) scheme(s1mono) name(Populistcult, replace)

graph combine Technocraticcult PartyDemocraticcult Populistcult, ysize(1.7) xsize(4) row(1) graphregion(color(white))


// Appendix Figure C3
mlogit techvspart polint natpoltrust c.econid_rs##c.econid_rs educat demage female, baseoutcome(0) vce(cluster country)
predict modF, p
graph twoway (qfitci modF econid_rs), graphregion(color(white)) xtitle("Economic Dimension") ytitle("Probability belonging Technocratic") ylabel(.2(.2).8) name(EconPartTech, replace)

mlogit techvspart polint natpoltrust c.cultid_rs##c.cultid_rs educat demage female, baseoutcome(0) vce(cluster country)
predict modI, p
graph twoway (qfitci modI cultid_rs), graphregion(color(white)) xtitle("Cultural Dimension") ytitle("Probability belonging Technocratic") ylabel(.2(.2).8) name(CultPartTech, replace)

graph combine EconPartTech CultPartTech, graphregion(color(white))


// Appendix Figure C4
mlogit techvspop polint natpoltrust c.econid_rs##c.econid_rs educat demage female, baseoutcome(0) vce(cluster country)
predict modD, p
graph twoway (qfitci modD econid_rs), graphregion(color(white)) xtitle("Economic Dimension") ytitle("Probability belonging Technocratic")ylabel(.2(.2).8) name(EconPopTech, replace)

mlogit techvspop polint natpoltrust c.cultid_rs##c.cultid_rs educat demage female, baseoutcome(0) vce(cluster country)
predict modG, p
graph twoway (qfitci modG cultid_rs) , graphregion(color(white)) xtitle("Cultural Dimension") ytitle("Probability belonging Technocratic") ylabel(.2(.2).8) name(CultPopTech, replace)

graph combine EconPopTech CultPopTech, graphregion(color(white))


// Appendix Figure D1
twoway (kdensity LR if class==3, by(country) bwidth(.45) k(gaussian) lcolor(red) lpattern(solid) ylab(0(.25).5)) (kdensity LR, bwidth(.45) k(gaussian) lcolor(black) lpattern(longdash)), graphregion(color(white)) scheme(s2mono) legend(label(1 "Technocrat") label(2 "Total") rows(1)) xtitle("General Left-Right") ytitle("Density")


// Appendix Figure D2
twoway (kdensity econid_rs if class==3, by(country) bwidth(.45) k(gaussian) lcolor(red) lpattern(solid) ylab(0(.25).5)) (kdensity econid_rs, bwidth(.45) k(gaussian) lcolor(black) lpattern(longdash)), graphregion(color(white)) scheme(s2mono) legend(label(1 "Technocrat") label(2 "Total") rows(1)) xtitle("Economic Dimension") ytitle("Density")


// Appendix Figure D3
twoway (kdensity LR if class==3, by(country) bwidth(.45) k(gaussian) lcolor(red) lpattern(solid) ylab(0(.25).5)) (kdensity LR, bwidth(.45) k(gaussian) lcolor(black) lpattern(longdash)), graphregion(color(white)) scheme(s2mono) legend(label(1 "Technocrat") label(2 "Total") rows(1)) xtitle("Cultural Dimension") ytitle("Density")


// Appendix Figure D4
twoway (kdensity LR if class==3, by(country) k(gaussian) lcolor(red) lpattern(solid)) (kdensity LR if class==4, k(gaussian) lcolor(green) lpattern(solid)) (kdensity LR if class==5, k(gaussian) lcolor(gray) lpattern(solid)), graphregion(color(white)) scheme(s2mono) legend(label(1 "Technocrat") label(2 "Party-Dem.") label(3 "Populist") rows(1)) xtitle("General Left-Right") ytitle("Density")


// Appendix Figure D5
twoway (kdensity econid_rs if class==3, by(country) k(gaussian) lcolor(red) lpattern(solid) ylabel(0(.2).4)) (kdensity econid_rs if class==4, k(gaussian) lcolor(green) lpattern(solid)) (kdensity econid_rs if class==5, k(gaussian) lcolor(gray) lpattern(solid)), graphregion(color(white)) scheme(s2mono) legend(label(1 "Technocrat") label(2 "Party-Dem.") label(3 "Populist") rows(1)) xtitle("Economic Dimension") ytitle("Density")


// Appendix Figure D6
twoway (kdensity cultid_rs if class==3, by(country) k(gaussian) lcolor(red) lpattern(solid) ylabel(0(.2).4)) (kdensity cultid_rs if class==4, k(gaussian) lcolor(green) lpattern(solid)) (kdensity cultid_rs if class==5, k(gaussian) lcolor(gray) lpattern(solid)), graphregion(color(white)) scheme(s2mono) legend(label(1 "Technocrat") label(2 "Party-Dem.") label(3 "Populist") rows(1)) xtitle("Cultural Dimension") ytitle("Density")


// Appendix Figure D7
hexplot cultid_rs econid_rs if class==3, by(country, graphregion(color(white)) legend(off) title("Technocrat")) colors(tab Blue-Teal) xbins(11) ybins(11) ylabel(, nogrid) xtitle("Economic") ytitle("Cultural") aspect(.8)

hexplot cultid_rs econid_rs if class==4, by(country, graphregion(color(white)) legend(off) title("Party-democratic")) colors(tab Blue-Teal) xbins(11) ybins(11) ylabel(, nogrid) xtitle("Economic") ytitle("Cultural") aspect(.8)

hexplot cultid_rs econid_rs if class==5, by(country, graphregion(color(white)) legend(off) title("Populist")) colors(tab Blue-Teal) xbins(11) ybins(11) ylabel(, nogrid) xtitle("Economic") ytitle("Cultural") aspect(.8)


// Appendix Table D1 & D2
mlogit class polint natpoltrust LR LR2 educat demage female if country == 1 , baseoutcome(3) 
mlogit class polint natpoltrust LR LR2 educat demage female if country == 2 , baseoutcome(3) 
mlogit class polint natpoltrust LR LR2 educat demage female if country == 3 , baseoutcome(3) 
mlogit class polint natpoltrust LR LR2 educat demage female if country == 4 , baseoutcome(3) 
mlogit class polint natpoltrust LR LR2 educat demage female if country == 5 , baseoutcome(3) 
mlogit class polint natpoltrust LR LR2 educat demage female if country == 6 , baseoutcome(3) 
mlogit class polint natpoltrust LR LR2 educat demage female if country == 9 , baseoutcome(3) 
mlogit class polint natpoltrust LR LR2 educat demage female if country == 10 , baseoutcome(3) 
mlogit class polint natpoltrust LR LR2 educat demage female if country == 11 , baseoutcome(3) 


// Appendix Table D3 & D5
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 1 , baseoutcome(3) 
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 2 , baseoutcome(3) 
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 3 , baseoutcome(3) 
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 4 , baseoutcome(3) 
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 5 , baseoutcome(3) 
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 6 , baseoutcome(3) 
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 9 , baseoutcome(3) 
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 10 , baseoutcome(3) 
mlogit class polint natpoltrust econid_rs econid_rs2 educat demage female if country == 11 , baseoutcome(3) 


// Appendix Table D3.1
mlogit class econid_rs polint natpoltrust educat demage female if country == 1 , baseoutcome(3) 
mlogit class econid_rs polint natpoltrust educat demage female if country == 2 , baseoutcome(3) 
mlogit class econid_rs polint natpoltrust educat demage female if country == 3 , baseoutcome(3) 
mlogit class econid_rs polint natpoltrust educat demage female if country == 4 , baseoutcome(3) 
mlogit class econid_rs polint natpoltrust educat demage female if country == 5 , baseoutcome(3) 
mlogit class econid_rs polint natpoltrust educat demage female if country == 6 , baseoutcome(3) 
mlogit class econid_rs polint natpoltrust educat demage female if country == 9 , baseoutcome(3) 
mlogit class econid_rs polint natpoltrust educat demage female if country == 10 , baseoutcome(3) 
mlogit class econid_rs polint natpoltrust educat demage female if country == 11 , baseoutcome(3) 


// Appendix Table D4 & D6
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 1 , baseoutcome(3) 
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 2 , baseoutcome(3) 
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 3 , baseoutcome(3) 
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 4 , baseoutcome(3) 
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 5 , baseoutcome(3) 
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 6 , baseoutcome(3) 
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 9 , baseoutcome(3) 
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 10 , baseoutcome(3) 
mlogit class cultid_rs cultid_rs2 polint natpoltrust educat demage female if country == 11 , baseoutcome(3) 


// Appendix Table D4.1 & D6.1
mlogit class cultid_rs polint natpoltrust educat demage female if country == 1 , baseoutcome(3) 
mlogit class cultid_rs polint natpoltrust educat demage female if country == 2 , baseoutcome(3) 
mlogit class cultid_rs polint natpoltrust educat demage female if country == 3 , baseoutcome(3) 
mlogit class cultid_rs polint natpoltrust educat demage female if country == 4 , baseoutcome(3) 
mlogit class cultid_rs polint natpoltrust educat demage female if country == 5 , baseoutcome(3) 
mlogit class cultid_rs polint natpoltrust educat demage female if country == 6 , baseoutcome(3) 
mlogit class cultid_rs polint natpoltrust educat demage female if country == 9 , baseoutcome(3) 
mlogit class cultid_rs polint natpoltrust educat demage female if country == 10 , baseoutcome(3) 
mlogit class cultid_rs polint natpoltrust educat demage female if country == 11 , baseoutcome(3) 


// Appendix Table E1 (see "EJPR_technocraticvoter.R")
reg predtech LR polint natpoltrust educat demage female, vce(cluster country)
reg predtech LR LR2 polint natpoltrust educat demage female, vce(cluster country)
reg predtech polint natpoltrust c.econid_rs educat demage female, vce(cluster country) 
reg predtech polint natpoltrust c.econid_rs##c.econid_rs educat demage femal, vce(cluster country)
reg predtech polint natpoltrust c.cultid_rs educat demage female, vce(cluster country)
reg predtech polint natpoltrust c.cultid_rs##c.cultid_rs educat demage female, vce(cluster country)
